/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubContentSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubContentStatus;
import software.amazon.awssdk.services.sagemaker.model.HubContentSupportStatus;
import software.amazon.awssdk.services.sagemaker.model.HubContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HubContentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HubContentInfo> {
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(HubContentInfo.getter(HubContentInfo::hubContentName)).setter(HubContentInfo.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentArn").getter(HubContentInfo.getter(HubContentInfo::hubContentArn)).setter(HubContentInfo.setter(Builder::hubContentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentArn").build()}).build();
    private static final SdkField<String> SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SageMakerPublicHubContentArn").getter(HubContentInfo.getter(HubContentInfo::sageMakerPublicHubContentArn)).setter(HubContentInfo.setter(Builder::sageMakerPublicHubContentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPublicHubContentArn").build()}).build();
    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentVersion").getter(HubContentInfo.getter(HubContentInfo::hubContentVersion)).setter(HubContentInfo.setter(Builder::hubContentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()}).build();
    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentType").getter(HubContentInfo.getter(HubContentInfo::hubContentTypeAsString)).setter(HubContentInfo.setter(Builder::hubContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()}).build();
    private static final SdkField<String> DOCUMENT_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentSchemaVersion").getter(HubContentInfo.getter(HubContentInfo::documentSchemaVersion)).setter(HubContentInfo.setter(Builder::documentSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSchemaVersion").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDisplayName").getter(HubContentInfo.getter(HubContentInfo::hubContentDisplayName)).setter(HubContentInfo.setter(Builder::hubContentDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDescription").getter(HubContentInfo.getter(HubContentInfo::hubContentDescription)).setter(HubContentInfo.setter(Builder::hubContentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build()}).build();
    private static final SdkField<String> SUPPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportStatus").getter(HubContentInfo.getter(HubContentInfo::supportStatusAsString)).setter(HubContentInfo.setter(Builder::supportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportStatus").build()}).build();
    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubContentSearchKeywords").getter(HubContentInfo.getter(HubContentInfo::hubContentSearchKeywords)).setter(HubContentInfo.setter(Builder::hubContentSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HUB_CONTENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentStatus").getter(HubContentInfo.getter(HubContentInfo::hubContentStatusAsString)).setter(HubContentInfo.setter(Builder::hubContentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(HubContentInfo.getter(HubContentInfo::creationTime)).setter(HubContentInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> ORIGINAL_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OriginalCreationTime").getter(HubContentInfo.getter(HubContentInfo::originalCreationTime)).setter(HubContentInfo.setter(Builder::originalCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalCreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_NAME_FIELD, HUB_CONTENT_ARN_FIELD, SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD, HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_TYPE_FIELD, DOCUMENT_SCHEMA_VERSION_FIELD, HUB_CONTENT_DISPLAY_NAME_FIELD, HUB_CONTENT_DESCRIPTION_FIELD, SUPPORT_STATUS_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD, HUB_CONTENT_STATUS_FIELD, CREATION_TIME_FIELD, ORIGINAL_CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HubContentInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hubContentName;
    private final String hubContentArn;
    private final String sageMakerPublicHubContentArn;
    private final String hubContentVersion;
    private final String hubContentType;
    private final String documentSchemaVersion;
    private final String hubContentDisplayName;
    private final String hubContentDescription;
    private final String supportStatus;
    private final List<String> hubContentSearchKeywords;
    private final String hubContentStatus;
    private final Instant creationTime;
    private final Instant originalCreationTime;

    private HubContentInfo(BuilderImpl builder) {
        this.hubContentName = builder.hubContentName;
        this.hubContentArn = builder.hubContentArn;
        this.sageMakerPublicHubContentArn = builder.sageMakerPublicHubContentArn;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentType = builder.hubContentType;
        this.documentSchemaVersion = builder.documentSchemaVersion;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.supportStatus = builder.supportStatus;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.hubContentStatus = builder.hubContentStatus;
        this.creationTime = builder.creationTime;
        this.originalCreationTime = builder.originalCreationTime;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final String hubContentArn() {
        return this.hubContentArn;
    }

    public final String sageMakerPublicHubContentArn() {
        return this.sageMakerPublicHubContentArn;
    }

    public final String hubContentVersion() {
        return this.hubContentVersion;
    }

    public final HubContentType hubContentType() {
        return HubContentType.fromValue(this.hubContentType);
    }

    public final String hubContentTypeAsString() {
        return this.hubContentType;
    }

    public final String documentSchemaVersion() {
        return this.documentSchemaVersion;
    }

    public final String hubContentDisplayName() {
        return this.hubContentDisplayName;
    }

    public final String hubContentDescription() {
        return this.hubContentDescription;
    }

    public final HubContentSupportStatus supportStatus() {
        return HubContentSupportStatus.fromValue(this.supportStatus);
    }

    public final String supportStatusAsString() {
        return this.supportStatus;
    }

    public final boolean hasHubContentSearchKeywords() {
        return this.hubContentSearchKeywords != null && !(this.hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubContentSearchKeywords() {
        return this.hubContentSearchKeywords;
    }

    public final HubContentStatus hubContentStatus() {
        return HubContentStatus.fromValue(this.hubContentStatus);
    }

    public final String hubContentStatusAsString() {
        return this.hubContentStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant originalCreationTime() {
        return this.originalCreationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerPublicHubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalCreationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HubContentInfo)) {
            return false;
        }
        HubContentInfo other = (HubContentInfo)obj;
        return Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.hubContentArn(), other.hubContentArn()) && Objects.equals(this.sageMakerPublicHubContentArn(), other.sageMakerPublicHubContentArn()) && Objects.equals(this.hubContentVersion(), other.hubContentVersion()) && Objects.equals(this.hubContentTypeAsString(), other.hubContentTypeAsString()) && Objects.equals(this.documentSchemaVersion(), other.documentSchemaVersion()) && Objects.equals(this.hubContentDisplayName(), other.hubContentDisplayName()) && Objects.equals(this.hubContentDescription(), other.hubContentDescription()) && Objects.equals(this.supportStatusAsString(), other.supportStatusAsString()) && this.hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords() && Objects.equals(this.hubContentSearchKeywords(), other.hubContentSearchKeywords()) && Objects.equals(this.hubContentStatusAsString(), other.hubContentStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.originalCreationTime(), other.originalCreationTime());
    }

    public final String toString() {
        return ToString.builder((String)"HubContentInfo").add("HubContentName", (Object)this.hubContentName()).add("HubContentArn", (Object)this.hubContentArn()).add("SageMakerPublicHubContentArn", (Object)this.sageMakerPublicHubContentArn()).add("HubContentVersion", (Object)this.hubContentVersion()).add("HubContentType", (Object)this.hubContentTypeAsString()).add("DocumentSchemaVersion", (Object)this.documentSchemaVersion()).add("HubContentDisplayName", (Object)this.hubContentDisplayName()).add("HubContentDescription", (Object)this.hubContentDescription()).add("SupportStatus", (Object)this.supportStatusAsString()).add("HubContentSearchKeywords", this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null).add("HubContentStatus", (Object)this.hubContentStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("OriginalCreationTime", (Object)this.originalCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "HubContentArn": {
                return Optional.ofNullable(clazz.cast(this.hubContentArn()));
            }
            case "SageMakerPublicHubContentArn": {
                return Optional.ofNullable(clazz.cast(this.sageMakerPublicHubContentArn()));
            }
            case "HubContentVersion": {
                return Optional.ofNullable(clazz.cast(this.hubContentVersion()));
            }
            case "HubContentType": {
                return Optional.ofNullable(clazz.cast(this.hubContentTypeAsString()));
            }
            case "DocumentSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.documentSchemaVersion()));
            }
            case "HubContentDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubContentDisplayName()));
            }
            case "HubContentDescription": {
                return Optional.ofNullable(clazz.cast(this.hubContentDescription()));
            }
            case "SupportStatus": {
                return Optional.ofNullable(clazz.cast(this.supportStatusAsString()));
            }
            case "HubContentSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubContentSearchKeywords()));
            }
            case "HubContentStatus": {
                return Optional.ofNullable(clazz.cast(this.hubContentStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "OriginalCreationTime": {
                return Optional.ofNullable(clazz.cast(this.originalCreationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentArn", HUB_CONTENT_ARN_FIELD);
        map.put("SageMakerPublicHubContentArn", SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("DocumentSchemaVersion", DOCUMENT_SCHEMA_VERSION_FIELD);
        map.put("HubContentDisplayName", HUB_CONTENT_DISPLAY_NAME_FIELD);
        map.put("HubContentDescription", HUB_CONTENT_DESCRIPTION_FIELD);
        map.put("SupportStatus", SUPPORT_STATUS_FIELD);
        map.put("HubContentSearchKeywords", HUB_CONTENT_SEARCH_KEYWORDS_FIELD);
        map.put("HubContentStatus", HUB_CONTENT_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("OriginalCreationTime", ORIGINAL_CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HubContentInfo, T> g) {
        return obj -> g.apply((HubContentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hubContentName;
        private String hubContentArn;
        private String sageMakerPublicHubContentArn;
        private String hubContentVersion;
        private String hubContentType;
        private String documentSchemaVersion;
        private String hubContentDisplayName;
        private String hubContentDescription;
        private String supportStatus;
        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private String hubContentStatus;
        private Instant creationTime;
        private Instant originalCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HubContentInfo model) {
            this.hubContentName(model.hubContentName);
            this.hubContentArn(model.hubContentArn);
            this.sageMakerPublicHubContentArn(model.sageMakerPublicHubContentArn);
            this.hubContentVersion(model.hubContentVersion);
            this.hubContentType(model.hubContentType);
            this.documentSchemaVersion(model.documentSchemaVersion);
            this.hubContentDisplayName(model.hubContentDisplayName);
            this.hubContentDescription(model.hubContentDescription);
            this.supportStatus(model.supportStatus);
            this.hubContentSearchKeywords(model.hubContentSearchKeywords);
            this.hubContentStatus(model.hubContentStatus);
            this.creationTime(model.creationTime);
            this.originalCreationTime(model.originalCreationTime);
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentArn() {
            return this.hubContentArn;
        }

        public final void setHubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
        }

        @Override
        public final Builder hubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
            return this;
        }

        public final String getSageMakerPublicHubContentArn() {
            return this.sageMakerPublicHubContentArn;
        }

        public final void setSageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
        }

        @Override
        public final Builder sageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
            return this;
        }

        public final String getHubContentVersion() {
            return this.hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentType() {
            return this.hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getDocumentSchemaVersion() {
            return this.documentSchemaVersion;
        }

        public final void setDocumentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
        }

        @Override
        public final Builder documentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
            return this;
        }

        public final String getHubContentDisplayName() {
            return this.hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return this.hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final String getSupportStatus() {
            return this.supportStatus;
        }

        public final void setSupportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
        }

        @Override
        public final Builder supportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
            return this;
        }

        @Override
        public final Builder supportStatus(HubContentSupportStatus supportStatus) {
            this.supportStatus(supportStatus == null ? null : supportStatus.toString());
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (this.hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String ... hubContentSearchKeywords) {
            this.hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final String getHubContentStatus() {
            return this.hubContentStatus;
        }

        public final void setHubContentStatus(String hubContentStatus) {
            this.hubContentStatus = hubContentStatus;
        }

        @Override
        public final Builder hubContentStatus(String hubContentStatus) {
            this.hubContentStatus = hubContentStatus;
            return this;
        }

        @Override
        public final Builder hubContentStatus(HubContentStatus hubContentStatus) {
            this.hubContentStatus(hubContentStatus == null ? null : hubContentStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getOriginalCreationTime() {
            return this.originalCreationTime;
        }

        public final void setOriginalCreationTime(Instant originalCreationTime) {
            this.originalCreationTime = originalCreationTime;
        }

        @Override
        public final Builder originalCreationTime(Instant originalCreationTime) {
            this.originalCreationTime = originalCreationTime;
            return this;
        }

        public HubContentInfo build() {
            return new HubContentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HubContentInfo> {
        public Builder hubContentName(String var1);

        public Builder hubContentArn(String var1);

        public Builder sageMakerPublicHubContentArn(String var1);

        public Builder hubContentVersion(String var1);

        public Builder hubContentType(String var1);

        public Builder hubContentType(HubContentType var1);

        public Builder documentSchemaVersion(String var1);

        public Builder hubContentDisplayName(String var1);

        public Builder hubContentDescription(String var1);

        public Builder supportStatus(String var1);

        public Builder supportStatus(HubContentSupportStatus var1);

        public Builder hubContentSearchKeywords(Collection<String> var1);

        public Builder hubContentSearchKeywords(String ... var1);

        public Builder hubContentStatus(String var1);

        public Builder hubContentStatus(HubContentStatus var1);

        public Builder creationTime(Instant var1);

        public Builder originalCreationTime(Instant var1);
    }
}

