/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ActionSummary;
import software.amazon.awssdk.services.sagemaker.model.ListActionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListActionsResponse;

public class ListActionsIterable
implements SdkIterable<ListActionsResponse> {
    private final SageMakerClient client;
    private final ListActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActionsIterable(SageMakerClient client, ListActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActionsResponseFetcher();
    }

    public Iterator<ListActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionSummary> actionSummaries() {
        Function<ListActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionSummaries() != null) {
                return response.actionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActionsResponseFetcher
    implements SyncPageFetcher<ListActionsResponse> {
        private ListActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActionsResponse nextPage(ListActionsResponse previousPage) {
            if (previousPage == null) {
                return ListActionsIterable.this.client.listActions(ListActionsIterable.this.firstRequest);
            }
            return ListActionsIterable.this.client.listActions((ListActionsRequest)((Object)ListActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

