/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelVariantConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelVariantConfig> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ModelVariantConfig.getter(ModelVariantConfig::modelName)).setter(ModelVariantConfig.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(ModelVariantConfig.getter(ModelVariantConfig::variantName)).setter(ModelVariantConfig.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<ModelInfrastructureConfig> INFRASTRUCTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfrastructureConfig").getter(ModelVariantConfig.getter(ModelVariantConfig::infrastructureConfig)).setter(ModelVariantConfig.setter(Builder::infrastructureConfig)).constructor(ModelInfrastructureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, VARIANT_NAME_FIELD, INFRASTRUCTURE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelVariantConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String variantName;
    private final ModelInfrastructureConfig infrastructureConfig;

    private ModelVariantConfig(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.variantName = builder.variantName;
        this.infrastructureConfig = builder.infrastructureConfig;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final ModelInfrastructureConfig infrastructureConfig() {
        return this.infrastructureConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVariantConfig)) {
            return false;
        }
        ModelVariantConfig other = (ModelVariantConfig)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.infrastructureConfig(), other.infrastructureConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ModelVariantConfig").add("ModelName", (Object)this.modelName()).add("VariantName", (Object)this.variantName()).add("InfrastructureConfig", (Object)this.infrastructureConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "InfrastructureConfig": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("InfrastructureConfig", INFRASTRUCTURE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelVariantConfig, T> g) {
        return obj -> g.apply((ModelVariantConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String variantName;
        private ModelInfrastructureConfig infrastructureConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVariantConfig model) {
            this.modelName(model.modelName);
            this.variantName(model.variantName);
            this.infrastructureConfig(model.infrastructureConfig);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final ModelInfrastructureConfig.Builder getInfrastructureConfig() {
            return this.infrastructureConfig != null ? this.infrastructureConfig.toBuilder() : null;
        }

        public final void setInfrastructureConfig(ModelInfrastructureConfig.BuilderImpl infrastructureConfig) {
            this.infrastructureConfig = infrastructureConfig != null ? infrastructureConfig.build() : null;
        }

        @Override
        public final Builder infrastructureConfig(ModelInfrastructureConfig infrastructureConfig) {
            this.infrastructureConfig = infrastructureConfig;
            return this;
        }

        public ModelVariantConfig build() {
            return new ModelVariantConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelVariantConfig> {
        public Builder modelName(String var1);

        public Builder variantName(String var1);

        public Builder infrastructureConfig(ModelInfrastructureConfig var1);

        default public Builder infrastructureConfig(Consumer<ModelInfrastructureConfig.Builder> infrastructureConfig) {
            return this.infrastructureConfig((ModelInfrastructureConfig)((ModelInfrastructureConfig.Builder)ModelInfrastructureConfig.builder().applyMutation(infrastructureConfig)).build());
        }
    }
}

