/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(InferenceComponentSummary.getter(InferenceComponentSummary::creationTime)).setter(InferenceComponentSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> INFERENCE_COMPONENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentArn").getter(InferenceComponentSummary.getter(InferenceComponentSummary::inferenceComponentArn)).setter(InferenceComponentSummary.setter(Builder::inferenceComponentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentArn").build()}).build();
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentName").getter(InferenceComponentSummary.getter(InferenceComponentSummary::inferenceComponentName)).setter(InferenceComponentSummary.setter(Builder::inferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(InferenceComponentSummary.getter(InferenceComponentSummary::endpointArn)).setter(InferenceComponentSummary.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(InferenceComponentSummary.getter(InferenceComponentSummary::endpointName)).setter(InferenceComponentSummary.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(InferenceComponentSummary.getter(InferenceComponentSummary::variantName)).setter(InferenceComponentSummary.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<String> INFERENCE_COMPONENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentStatus").getter(InferenceComponentSummary.getter(InferenceComponentSummary::inferenceComponentStatusAsString)).setter(InferenceComponentSummary.setter(Builder::inferenceComponentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(InferenceComponentSummary.getter(InferenceComponentSummary::lastModifiedTime)).setter(InferenceComponentSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, INFERENCE_COMPONENT_ARN_FIELD, INFERENCE_COMPONENT_NAME_FIELD, ENDPOINT_ARN_FIELD, ENDPOINT_NAME_FIELD, VARIANT_NAME_FIELD, INFERENCE_COMPONENT_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceComponentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String inferenceComponentArn;
    private final String inferenceComponentName;
    private final String endpointArn;
    private final String endpointName;
    private final String variantName;
    private final String inferenceComponentStatus;
    private final Instant lastModifiedTime;

    private InferenceComponentSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.inferenceComponentArn = builder.inferenceComponentArn;
        this.inferenceComponentName = builder.inferenceComponentName;
        this.endpointArn = builder.endpointArn;
        this.endpointName = builder.endpointName;
        this.variantName = builder.variantName;
        this.inferenceComponentStatus = builder.inferenceComponentStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String inferenceComponentArn() {
        return this.inferenceComponentArn;
    }

    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final InferenceComponentStatus inferenceComponentStatus() {
        return InferenceComponentStatus.fromValue(this.inferenceComponentStatus);
    }

    public final String inferenceComponentStatusAsString() {
        return this.inferenceComponentStatus;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentSummary)) {
            return false;
        }
        InferenceComponentSummary other = (InferenceComponentSummary)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.inferenceComponentArn(), other.inferenceComponentArn()) && Objects.equals(this.inferenceComponentName(), other.inferenceComponentName()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.inferenceComponentStatusAsString(), other.inferenceComponentStatusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentSummary").add("CreationTime", (Object)this.creationTime()).add("InferenceComponentArn", (Object)this.inferenceComponentArn()).add("InferenceComponentName", (Object)this.inferenceComponentName()).add("EndpointArn", (Object)this.endpointArn()).add("EndpointName", (Object)this.endpointName()).add("VariantName", (Object)this.variantName()).add("InferenceComponentStatus", (Object)this.inferenceComponentStatusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "InferenceComponentArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentArn()));
            }
            case "InferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentName()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "InferenceComponentStatus": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentStatusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("InferenceComponentArn", INFERENCE_COMPONENT_ARN_FIELD);
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("InferenceComponentStatus", INFERENCE_COMPONENT_STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentSummary, T> g) {
        return obj -> g.apply((InferenceComponentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String inferenceComponentArn;
        private String inferenceComponentName;
        private String endpointArn;
        private String endpointName;
        private String variantName;
        private String inferenceComponentStatus;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentSummary model) {
            this.creationTime(model.creationTime);
            this.inferenceComponentArn(model.inferenceComponentArn);
            this.inferenceComponentName(model.inferenceComponentName);
            this.endpointArn(model.endpointArn);
            this.endpointName(model.endpointName);
            this.variantName(model.variantName);
            this.inferenceComponentStatus(model.inferenceComponentStatus);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getInferenceComponentArn() {
            return this.inferenceComponentArn;
        }

        public final void setInferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
        }

        @Override
        public final Builder inferenceComponentArn(String inferenceComponentArn) {
            this.inferenceComponentArn = inferenceComponentArn;
            return this;
        }

        public final String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final String getInferenceComponentStatus() {
            return this.inferenceComponentStatus;
        }

        public final void setInferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
        }

        @Override
        public final Builder inferenceComponentStatus(String inferenceComponentStatus) {
            this.inferenceComponentStatus = inferenceComponentStatus;
            return this;
        }

        @Override
        public final Builder inferenceComponentStatus(InferenceComponentStatus inferenceComponentStatus) {
            this.inferenceComponentStatus(inferenceComponentStatus == null ? null : inferenceComponentStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public InferenceComponentSummary build() {
            return new InferenceComponentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentSummary> {
        public Builder creationTime(Instant var1);

        public Builder inferenceComponentArn(String var1);

        public Builder inferenceComponentName(String var1);

        public Builder endpointArn(String var1);

        public Builder endpointName(String var1);

        public Builder variantName(String var1);

        public Builder inferenceComponentStatus(String var1);

        public Builder inferenceComponentStatus(InferenceComponentStatus var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

