/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubContentSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubContentSupportStatus;
import software.amazon.awssdk.services.sagemaker.model.HubContentType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHubContentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateHubContentRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubName)).setter(UpdateHubContentRequest.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentName)).setter(UpdateHubContentRequest.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentType").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentTypeAsString)).setter(UpdateHubContentRequest.setter(Builder::hubContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()}).build();
    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentVersion").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentVersion)).setter(UpdateHubContentRequest.setter(Builder::hubContentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDisplayName").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentDisplayName)).setter(UpdateHubContentRequest.setter(Builder::hubContentDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build()}).build();
    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentDescription").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentDescription)).setter(UpdateHubContentRequest.setter(Builder::hubContentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build()}).build();
    private static final SdkField<String> HUB_CONTENT_MARKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentMarkdown").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentMarkdown)).setter(UpdateHubContentRequest.setter(Builder::hubContentMarkdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentMarkdown").build()}).build();
    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubContentSearchKeywords").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::hubContentSearchKeywords)).setter(UpdateHubContentRequest.setter(Builder::hubContentSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUPPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportStatus").getter(UpdateHubContentRequest.getter(UpdateHubContentRequest::supportStatusAsString)).setter(UpdateHubContentRequest.setter(Builder::supportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_CONTENT_NAME_FIELD, HUB_CONTENT_TYPE_FIELD, HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_DISPLAY_NAME_FIELD, HUB_CONTENT_DESCRIPTION_FIELD, HUB_CONTENT_MARKDOWN_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD, SUPPORT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHubContentRequest.memberNameToFieldInitializer();
    private final String hubName;
    private final String hubContentName;
    private final String hubContentType;
    private final String hubContentVersion;
    private final String hubContentDisplayName;
    private final String hubContentDescription;
    private final String hubContentMarkdown;
    private final List<String> hubContentSearchKeywords;
    private final String supportStatus;

    private UpdateHubContentRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentName = builder.hubContentName;
        this.hubContentType = builder.hubContentType;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.hubContentMarkdown = builder.hubContentMarkdown;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.supportStatus = builder.supportStatus;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final HubContentType hubContentType() {
        return HubContentType.fromValue(this.hubContentType);
    }

    public final String hubContentTypeAsString() {
        return this.hubContentType;
    }

    public final String hubContentVersion() {
        return this.hubContentVersion;
    }

    public final String hubContentDisplayName() {
        return this.hubContentDisplayName;
    }

    public final String hubContentDescription() {
        return this.hubContentDescription;
    }

    public final String hubContentMarkdown() {
        return this.hubContentMarkdown;
    }

    public final boolean hasHubContentSearchKeywords() {
        return this.hubContentSearchKeywords != null && !(this.hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubContentSearchKeywords() {
        return this.hubContentSearchKeywords;
    }

    public final HubContentSupportStatus supportStatus() {
        return HubContentSupportStatus.fromValue(this.supportStatus);
    }

    public final String supportStatusAsString() {
        return this.supportStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHubContentRequest)) {
            return false;
        }
        UpdateHubContentRequest other = (UpdateHubContentRequest)((Object)obj);
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.hubContentTypeAsString(), other.hubContentTypeAsString()) && Objects.equals(this.hubContentVersion(), other.hubContentVersion()) && Objects.equals(this.hubContentDisplayName(), other.hubContentDisplayName()) && Objects.equals(this.hubContentDescription(), other.hubContentDescription()) && Objects.equals(this.hubContentMarkdown(), other.hubContentMarkdown()) && this.hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords() && Objects.equals(this.hubContentSearchKeywords(), other.hubContentSearchKeywords()) && Objects.equals(this.supportStatusAsString(), other.supportStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHubContentRequest").add("HubName", (Object)this.hubName()).add("HubContentName", (Object)this.hubContentName()).add("HubContentType", (Object)this.hubContentTypeAsString()).add("HubContentVersion", (Object)this.hubContentVersion()).add("HubContentDisplayName", (Object)this.hubContentDisplayName()).add("HubContentDescription", (Object)this.hubContentDescription()).add("HubContentMarkdown", (Object)this.hubContentMarkdown()).add("HubContentSearchKeywords", this.hasHubContentSearchKeywords() ? this.hubContentSearchKeywords() : null).add("SupportStatus", (Object)this.supportStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "HubContentType": {
                return Optional.ofNullable(clazz.cast(this.hubContentTypeAsString()));
            }
            case "HubContentVersion": {
                return Optional.ofNullable(clazz.cast(this.hubContentVersion()));
            }
            case "HubContentDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubContentDisplayName()));
            }
            case "HubContentDescription": {
                return Optional.ofNullable(clazz.cast(this.hubContentDescription()));
            }
            case "HubContentMarkdown": {
                return Optional.ofNullable(clazz.cast(this.hubContentMarkdown()));
            }
            case "HubContentSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubContentSearchKeywords()));
            }
            case "SupportStatus": {
                return Optional.ofNullable(clazz.cast(this.supportStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("HubContentDisplayName", HUB_CONTENT_DISPLAY_NAME_FIELD);
        map.put("HubContentDescription", HUB_CONTENT_DESCRIPTION_FIELD);
        map.put("HubContentMarkdown", HUB_CONTENT_MARKDOWN_FIELD);
        map.put("HubContentSearchKeywords", HUB_CONTENT_SEARCH_KEYWORDS_FIELD);
        map.put("SupportStatus", SUPPORT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHubContentRequest, T> g) {
        return obj -> g.apply((UpdateHubContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hubName;
        private String hubContentName;
        private String hubContentType;
        private String hubContentVersion;
        private String hubContentDisplayName;
        private String hubContentDescription;
        private String hubContentMarkdown;
        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private String supportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHubContentRequest model) {
            super(model);
            this.hubName(model.hubName);
            this.hubContentName(model.hubContentName);
            this.hubContentType(model.hubContentType);
            this.hubContentVersion(model.hubContentVersion);
            this.hubContentDisplayName(model.hubContentDisplayName);
            this.hubContentDescription(model.hubContentDescription);
            this.hubContentMarkdown(model.hubContentMarkdown);
            this.hubContentSearchKeywords(model.hubContentSearchKeywords);
            this.supportStatus(model.supportStatus);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentType() {
            return this.hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getHubContentVersion() {
            return this.hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentDisplayName() {
            return this.hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return this.hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final String getHubContentMarkdown() {
            return this.hubContentMarkdown;
        }

        public final void setHubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
        }

        @Override
        public final Builder hubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (this.hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String ... hubContentSearchKeywords) {
            this.hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final String getSupportStatus() {
            return this.supportStatus;
        }

        public final void setSupportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
        }

        @Override
        public final Builder supportStatus(String supportStatus) {
            this.supportStatus = supportStatus;
            return this;
        }

        @Override
        public final Builder supportStatus(HubContentSupportStatus supportStatus) {
            this.supportStatus(supportStatus == null ? null : supportStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHubContentRequest build() {
            return new UpdateHubContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHubContentRequest> {
        public Builder hubName(String var1);

        public Builder hubContentName(String var1);

        public Builder hubContentType(String var1);

        public Builder hubContentType(HubContentType var1);

        public Builder hubContentVersion(String var1);

        public Builder hubContentDisplayName(String var1);

        public Builder hubContentDescription(String var1);

        public Builder hubContentMarkdown(String var1);

        public Builder hubContentSearchKeywords(Collection<String> var1);

        public Builder hubContentSearchKeywords(String ... var1);

        public Builder supportStatus(String var1);

        public Builder supportStatus(HubContentSupportStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

