/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ModelSummary.getter(ModelSummary::modelName)).setter(ModelSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(ModelSummary.getter(ModelSummary::modelArn)).setter(ModelSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ModelSummary.getter(ModelSummary::creationTime)).setter(ModelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelArn;
    private final Instant creationTime;

    private ModelSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.creationTime = builder.creationTime;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSummary)) {
            return false;
        }
        ModelSummary other = (ModelSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ModelSummary").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelSummary, T> g) {
        return obj -> g.apply((ModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSummary model) {
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.creationTime(model.creationTime);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public ModelSummary build() {
            return new ModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelSummary> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

