/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobSupportedContentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationJobPayloadConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationJobPayloadConfig> {
    private static final SdkField<String> SAMPLE_PAYLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SamplePayloadUrl").getter(RecommendationJobPayloadConfig.getter(RecommendationJobPayloadConfig::samplePayloadUrl)).setter(RecommendationJobPayloadConfig.setter(Builder::samplePayloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePayloadUrl").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedContentTypes").getter(RecommendationJobPayloadConfig.getter(RecommendationJobPayloadConfig::supportedContentTypes)).setter(RecommendationJobPayloadConfig.setter(Builder::supportedContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLE_PAYLOAD_URL_FIELD, SUPPORTED_CONTENT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendationJobPayloadConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String samplePayloadUrl;
    private final List<String> supportedContentTypes;

    private RecommendationJobPayloadConfig(BuilderImpl builder) {
        this.samplePayloadUrl = builder.samplePayloadUrl;
        this.supportedContentTypes = builder.supportedContentTypes;
    }

    public final String samplePayloadUrl() {
        return this.samplePayloadUrl;
    }

    public final boolean hasSupportedContentTypes() {
        return this.supportedContentTypes != null && !(this.supportedContentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedContentTypes() {
        return this.supportedContentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samplePayloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedContentTypes() ? this.supportedContentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobPayloadConfig)) {
            return false;
        }
        RecommendationJobPayloadConfig other = (RecommendationJobPayloadConfig)obj;
        return Objects.equals(this.samplePayloadUrl(), other.samplePayloadUrl()) && this.hasSupportedContentTypes() == other.hasSupportedContentTypes() && Objects.equals(this.supportedContentTypes(), other.supportedContentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationJobPayloadConfig").add("SamplePayloadUrl", (Object)this.samplePayloadUrl()).add("SupportedContentTypes", this.hasSupportedContentTypes() ? this.supportedContentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplePayloadUrl": {
                return Optional.ofNullable(clazz.cast(this.samplePayloadUrl()));
            }
            case "SupportedContentTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedContentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SamplePayloadUrl", SAMPLE_PAYLOAD_URL_FIELD);
        map.put("SupportedContentTypes", SUPPORTED_CONTENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobPayloadConfig, T> g) {
        return obj -> g.apply((RecommendationJobPayloadConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String samplePayloadUrl;
        private List<String> supportedContentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobPayloadConfig model) {
            this.samplePayloadUrl(model.samplePayloadUrl);
            this.supportedContentTypes(model.supportedContentTypes);
        }

        public final String getSamplePayloadUrl() {
            return this.samplePayloadUrl;
        }

        public final void setSamplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
        }

        @Override
        public final Builder samplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        public final Collection<String> getSupportedContentTypes() {
            if (this.supportedContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedContentTypes;
        }

        public final void setSupportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = RecommendationJobSupportedContentTypesCopier.copy(supportedContentTypes);
        }

        @Override
        public final Builder supportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = RecommendationJobSupportedContentTypesCopier.copy(supportedContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedContentTypes(String ... supportedContentTypes) {
            this.supportedContentTypes(Arrays.asList(supportedContentTypes));
            return this;
        }

        public RecommendationJobPayloadConfig build() {
            return new RecommendationJobPayloadConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationJobPayloadConfig> {
        public Builder samplePayloadUrl(String var1);

        public Builder supportedContentTypes(Collection<String> var1);

        public Builder supportedContentTypes(String ... var1);
    }
}

