/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CaptureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCaptureConfigSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCaptureConfigSummary> {
    private static final SdkField<Boolean> ENABLE_CAPTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCapture").getter(DataCaptureConfigSummary.getter(DataCaptureConfigSummary::enableCapture)).setter(DataCaptureConfigSummary.setter(Builder::enableCapture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCapture").build()}).build();
    private static final SdkField<String> CAPTURE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptureStatus").getter(DataCaptureConfigSummary.getter(DataCaptureConfigSummary::captureStatusAsString)).setter(DataCaptureConfigSummary.setter(Builder::captureStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureStatus").build()}).build();
    private static final SdkField<Integer> CURRENT_SAMPLING_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentSamplingPercentage").getter(DataCaptureConfigSummary.getter(DataCaptureConfigSummary::currentSamplingPercentage)).setter(DataCaptureConfigSummary.setter(Builder::currentSamplingPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSamplingPercentage").build()}).build();
    private static final SdkField<String> DESTINATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationS3Uri").getter(DataCaptureConfigSummary.getter(DataCaptureConfigSummary::destinationS3Uri)).setter(DataCaptureConfigSummary.setter(Builder::destinationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationS3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DataCaptureConfigSummary.getter(DataCaptureConfigSummary::kmsKeyId)).setter(DataCaptureConfigSummary.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_CAPTURE_FIELD, CAPTURE_STATUS_FIELD, CURRENT_SAMPLING_PERCENTAGE_FIELD, DESTINATION_S3_URI_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataCaptureConfigSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enableCapture;
    private final String captureStatus;
    private final Integer currentSamplingPercentage;
    private final String destinationS3Uri;
    private final String kmsKeyId;

    private DataCaptureConfigSummary(BuilderImpl builder) {
        this.enableCapture = builder.enableCapture;
        this.captureStatus = builder.captureStatus;
        this.currentSamplingPercentage = builder.currentSamplingPercentage;
        this.destinationS3Uri = builder.destinationS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final Boolean enableCapture() {
        return this.enableCapture;
    }

    public final CaptureStatus captureStatus() {
        return CaptureStatus.fromValue(this.captureStatus);
    }

    public final String captureStatusAsString() {
        return this.captureStatus;
    }

    public final Integer currentSamplingPercentage() {
        return this.currentSamplingPercentage;
    }

    public final String destinationS3Uri() {
        return this.destinationS3Uri;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCapture());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSamplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCaptureConfigSummary)) {
            return false;
        }
        DataCaptureConfigSummary other = (DataCaptureConfigSummary)obj;
        return Objects.equals(this.enableCapture(), other.enableCapture()) && Objects.equals(this.captureStatusAsString(), other.captureStatusAsString()) && Objects.equals(this.currentSamplingPercentage(), other.currentSamplingPercentage()) && Objects.equals(this.destinationS3Uri(), other.destinationS3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"DataCaptureConfigSummary").add("EnableCapture", (Object)this.enableCapture()).add("CaptureStatus", (Object)this.captureStatusAsString()).add("CurrentSamplingPercentage", (Object)this.currentSamplingPercentage()).add("DestinationS3Uri", (Object)this.destinationS3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableCapture": {
                return Optional.ofNullable(clazz.cast(this.enableCapture()));
            }
            case "CaptureStatus": {
                return Optional.ofNullable(clazz.cast(this.captureStatusAsString()));
            }
            case "CurrentSamplingPercentage": {
                return Optional.ofNullable(clazz.cast(this.currentSamplingPercentage()));
            }
            case "DestinationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnableCapture", ENABLE_CAPTURE_FIELD);
        map.put("CaptureStatus", CAPTURE_STATUS_FIELD);
        map.put("CurrentSamplingPercentage", CURRENT_SAMPLING_PERCENTAGE_FIELD);
        map.put("DestinationS3Uri", DESTINATION_S3_URI_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataCaptureConfigSummary, T> g) {
        return obj -> g.apply((DataCaptureConfigSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableCapture;
        private String captureStatus;
        private Integer currentSamplingPercentage;
        private String destinationS3Uri;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCaptureConfigSummary model) {
            this.enableCapture(model.enableCapture);
            this.captureStatus(model.captureStatus);
            this.currentSamplingPercentage(model.currentSamplingPercentage);
            this.destinationS3Uri(model.destinationS3Uri);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Boolean getEnableCapture() {
            return this.enableCapture;
        }

        public final void setEnableCapture(Boolean enableCapture) {
            this.enableCapture = enableCapture;
        }

        @Override
        public final Builder enableCapture(Boolean enableCapture) {
            this.enableCapture = enableCapture;
            return this;
        }

        public final String getCaptureStatus() {
            return this.captureStatus;
        }

        public final void setCaptureStatus(String captureStatus) {
            this.captureStatus = captureStatus;
        }

        @Override
        public final Builder captureStatus(String captureStatus) {
            this.captureStatus = captureStatus;
            return this;
        }

        @Override
        public final Builder captureStatus(CaptureStatus captureStatus) {
            this.captureStatus(captureStatus == null ? null : captureStatus.toString());
            return this;
        }

        public final Integer getCurrentSamplingPercentage() {
            return this.currentSamplingPercentage;
        }

        public final void setCurrentSamplingPercentage(Integer currentSamplingPercentage) {
            this.currentSamplingPercentage = currentSamplingPercentage;
        }

        @Override
        public final Builder currentSamplingPercentage(Integer currentSamplingPercentage) {
            this.currentSamplingPercentage = currentSamplingPercentage;
            return this;
        }

        public final String getDestinationS3Uri() {
            return this.destinationS3Uri;
        }

        public final void setDestinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
        }

        @Override
        public final Builder destinationS3Uri(String destinationS3Uri) {
            this.destinationS3Uri = destinationS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public DataCaptureConfigSummary build() {
            return new DataCaptureConfigSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCaptureConfigSummary> {
        public Builder enableCapture(Boolean var1);

        public Builder captureStatus(String var1);

        public Builder captureStatus(CaptureStatus var1);

        public Builder currentSamplingPercentage(Integer var1);

        public Builder destinationS3Uri(String var1);

        public Builder kmsKeyId(String var1);
    }
}

