/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.services.sagemaker.model.AutoMLMode;
import software.amazon.awssdk.services.sagemaker.model.CandidateGenerationConfig;
import software.amazon.awssdk.services.sagemaker.model.ProblemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TabularJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TabularJobConfig> {
    private static final SdkField<CandidateGenerationConfig> CANDIDATE_GENERATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CandidateGenerationConfig").getter(TabularJobConfig.getter(TabularJobConfig::candidateGenerationConfig)).setter(TabularJobConfig.setter(Builder::candidateGenerationConfig)).constructor(CandidateGenerationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateGenerationConfig").build()}).build();
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(TabularJobConfig.getter(TabularJobConfig::completionCriteria)).setter(TabularJobConfig.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<String> FEATURE_SPECIFICATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureSpecificationS3Uri").getter(TabularJobConfig.getter(TabularJobConfig::featureSpecificationS3Uri)).setter(TabularJobConfig.setter(Builder::featureSpecificationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureSpecificationS3Uri").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(TabularJobConfig.getter(TabularJobConfig::modeAsString)).setter(TabularJobConfig.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Boolean> GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GenerateCandidateDefinitionsOnly").getter(TabularJobConfig.getter(TabularJobConfig::generateCandidateDefinitionsOnly)).setter(TabularJobConfig.setter(Builder::generateCandidateDefinitionsOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateCandidateDefinitionsOnly").build()}).build();
    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProblemType").getter(TabularJobConfig.getter(TabularJobConfig::problemTypeAsString)).setter(TabularJobConfig.setter(Builder::problemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()}).build();
    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAttributeName").getter(TabularJobConfig.getter(TabularJobConfig::targetAttributeName)).setter(TabularJobConfig.setter(Builder::targetAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build()}).build();
    private static final SdkField<String> SAMPLE_WEIGHT_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleWeightAttributeName").getter(TabularJobConfig.getter(TabularJobConfig::sampleWeightAttributeName)).setter(TabularJobConfig.setter(Builder::sampleWeightAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleWeightAttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATE_GENERATION_CONFIG_FIELD, COMPLETION_CRITERIA_FIELD, FEATURE_SPECIFICATION_S3_URI_FIELD, MODE_FIELD, GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD, PROBLEM_TYPE_FIELD, TARGET_ATTRIBUTE_NAME_FIELD, SAMPLE_WEIGHT_ATTRIBUTE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TabularJobConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CandidateGenerationConfig candidateGenerationConfig;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final String featureSpecificationS3Uri;
    private final String mode;
    private final Boolean generateCandidateDefinitionsOnly;
    private final String problemType;
    private final String targetAttributeName;
    private final String sampleWeightAttributeName;

    private TabularJobConfig(BuilderImpl builder) {
        this.candidateGenerationConfig = builder.candidateGenerationConfig;
        this.completionCriteria = builder.completionCriteria;
        this.featureSpecificationS3Uri = builder.featureSpecificationS3Uri;
        this.mode = builder.mode;
        this.generateCandidateDefinitionsOnly = builder.generateCandidateDefinitionsOnly;
        this.problemType = builder.problemType;
        this.targetAttributeName = builder.targetAttributeName;
        this.sampleWeightAttributeName = builder.sampleWeightAttributeName;
    }

    public final CandidateGenerationConfig candidateGenerationConfig() {
        return this.candidateGenerationConfig;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final String featureSpecificationS3Uri() {
        return this.featureSpecificationS3Uri;
    }

    public final AutoMLMode mode() {
        return AutoMLMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Boolean generateCandidateDefinitionsOnly() {
        return this.generateCandidateDefinitionsOnly;
    }

    public final ProblemType problemType() {
        return ProblemType.fromValue(this.problemType);
    }

    public final String problemTypeAsString() {
        return this.problemType;
    }

    public final String targetAttributeName() {
        return this.targetAttributeName;
    }

    public final String sampleWeightAttributeName() {
        return this.sampleWeightAttributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateGenerationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSpecificationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generateCandidateDefinitionsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleWeightAttributeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TabularJobConfig)) {
            return false;
        }
        TabularJobConfig other = (TabularJobConfig)obj;
        return Objects.equals(this.candidateGenerationConfig(), other.candidateGenerationConfig()) && Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.featureSpecificationS3Uri(), other.featureSpecificationS3Uri()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.generateCandidateDefinitionsOnly(), other.generateCandidateDefinitionsOnly()) && Objects.equals(this.problemTypeAsString(), other.problemTypeAsString()) && Objects.equals(this.targetAttributeName(), other.targetAttributeName()) && Objects.equals(this.sampleWeightAttributeName(), other.sampleWeightAttributeName());
    }

    public final String toString() {
        return ToString.builder((String)"TabularJobConfig").add("CandidateGenerationConfig", (Object)this.candidateGenerationConfig()).add("CompletionCriteria", (Object)this.completionCriteria()).add("FeatureSpecificationS3Uri", (Object)this.featureSpecificationS3Uri()).add("Mode", (Object)this.modeAsString()).add("GenerateCandidateDefinitionsOnly", (Object)this.generateCandidateDefinitionsOnly()).add("ProblemType", (Object)this.problemTypeAsString()).add("TargetAttributeName", (Object)this.targetAttributeName()).add("SampleWeightAttributeName", (Object)this.sampleWeightAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CandidateGenerationConfig": {
                return Optional.ofNullable(clazz.cast(this.candidateGenerationConfig()));
            }
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "FeatureSpecificationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.featureSpecificationS3Uri()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "GenerateCandidateDefinitionsOnly": {
                return Optional.ofNullable(clazz.cast(this.generateCandidateDefinitionsOnly()));
            }
            case "ProblemType": {
                return Optional.ofNullable(clazz.cast(this.problemTypeAsString()));
            }
            case "TargetAttributeName": {
                return Optional.ofNullable(clazz.cast(this.targetAttributeName()));
            }
            case "SampleWeightAttributeName": {
                return Optional.ofNullable(clazz.cast(this.sampleWeightAttributeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CandidateGenerationConfig", CANDIDATE_GENERATION_CONFIG_FIELD);
        map.put("CompletionCriteria", COMPLETION_CRITERIA_FIELD);
        map.put("FeatureSpecificationS3Uri", FEATURE_SPECIFICATION_S3_URI_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("GenerateCandidateDefinitionsOnly", GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD);
        map.put("ProblemType", PROBLEM_TYPE_FIELD);
        map.put("TargetAttributeName", TARGET_ATTRIBUTE_NAME_FIELD);
        map.put("SampleWeightAttributeName", SAMPLE_WEIGHT_ATTRIBUTE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TabularJobConfig, T> g) {
        return obj -> g.apply((TabularJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CandidateGenerationConfig candidateGenerationConfig;
        private AutoMLJobCompletionCriteria completionCriteria;
        private String featureSpecificationS3Uri;
        private String mode;
        private Boolean generateCandidateDefinitionsOnly;
        private String problemType;
        private String targetAttributeName;
        private String sampleWeightAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TabularJobConfig model) {
            this.candidateGenerationConfig(model.candidateGenerationConfig);
            this.completionCriteria(model.completionCriteria);
            this.featureSpecificationS3Uri(model.featureSpecificationS3Uri);
            this.mode(model.mode);
            this.generateCandidateDefinitionsOnly(model.generateCandidateDefinitionsOnly);
            this.problemType(model.problemType);
            this.targetAttributeName(model.targetAttributeName);
            this.sampleWeightAttributeName(model.sampleWeightAttributeName);
        }

        public final CandidateGenerationConfig.Builder getCandidateGenerationConfig() {
            return this.candidateGenerationConfig != null ? this.candidateGenerationConfig.toBuilder() : null;
        }

        public final void setCandidateGenerationConfig(CandidateGenerationConfig.BuilderImpl candidateGenerationConfig) {
            this.candidateGenerationConfig = candidateGenerationConfig != null ? candidateGenerationConfig.build() : null;
        }

        @Override
        public final Builder candidateGenerationConfig(CandidateGenerationConfig candidateGenerationConfig) {
            this.candidateGenerationConfig = candidateGenerationConfig;
            return this;
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getFeatureSpecificationS3Uri() {
            return this.featureSpecificationS3Uri;
        }

        public final void setFeatureSpecificationS3Uri(String featureSpecificationS3Uri) {
            this.featureSpecificationS3Uri = featureSpecificationS3Uri;
        }

        @Override
        public final Builder featureSpecificationS3Uri(String featureSpecificationS3Uri) {
            this.featureSpecificationS3Uri = featureSpecificationS3Uri;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AutoMLMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getGenerateCandidateDefinitionsOnly() {
            return this.generateCandidateDefinitionsOnly;
        }

        public final void setGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
        }

        @Override
        public final Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
            return this;
        }

        public final String getProblemType() {
            return this.problemType;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final String getSampleWeightAttributeName() {
            return this.sampleWeightAttributeName;
        }

        public final void setSampleWeightAttributeName(String sampleWeightAttributeName) {
            this.sampleWeightAttributeName = sampleWeightAttributeName;
        }

        @Override
        public final Builder sampleWeightAttributeName(String sampleWeightAttributeName) {
            this.sampleWeightAttributeName = sampleWeightAttributeName;
            return this;
        }

        public TabularJobConfig build() {
            return new TabularJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TabularJobConfig> {
        public Builder candidateGenerationConfig(CandidateGenerationConfig var1);

        default public Builder candidateGenerationConfig(Consumer<CandidateGenerationConfig.Builder> candidateGenerationConfig) {
            return this.candidateGenerationConfig((CandidateGenerationConfig)((CandidateGenerationConfig.Builder)CandidateGenerationConfig.builder().applyMutation(candidateGenerationConfig)).build());
        }

        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder featureSpecificationS3Uri(String var1);

        public Builder mode(String var1);

        public Builder mode(AutoMLMode var1);

        public Builder generateCandidateDefinitionsOnly(Boolean var1);

        public Builder problemType(String var1);

        public Builder problemType(ProblemType var1);

        public Builder targetAttributeName(String var1);

        public Builder sampleWeightAttributeName(String var1);
    }
}

