/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitConfig> {
    private static final SdkField<String> REPOSITORY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryUrl").getter(GitConfig.getter(GitConfig::repositoryUrl)).setter(GitConfig.setter(Builder::repositoryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryUrl").build()}).build();
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Branch").getter(GitConfig.getter(GitConfig::branch)).setter(GitConfig.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(GitConfig.getter(GitConfig::secretArn)).setter(GitConfig.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_URL_FIELD, BRANCH_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GitConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String repositoryUrl;
    private final String branch;
    private final String secretArn;

    private GitConfig(BuilderImpl builder) {
        this.repositoryUrl = builder.repositoryUrl;
        this.branch = builder.branch;
        this.secretArn = builder.secretArn;
    }

    public final String repositoryUrl() {
        return this.repositoryUrl;
    }

    public final String branch() {
        return this.branch;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitConfig)) {
            return false;
        }
        GitConfig other = (GitConfig)obj;
        return Objects.equals(this.repositoryUrl(), other.repositoryUrl()) && Objects.equals(this.branch(), other.branch()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder((String)"GitConfig").add("RepositoryUrl", (Object)this.repositoryUrl()).add("Branch", (Object)this.branch()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryUrl": {
                return Optional.ofNullable(clazz.cast(this.repositoryUrl()));
            }
            case "Branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RepositoryUrl", REPOSITORY_URL_FIELD);
        map.put("Branch", BRANCH_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GitConfig, T> g) {
        return obj -> g.apply((GitConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryUrl;
        private String branch;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GitConfig model) {
            this.repositoryUrl(model.repositoryUrl);
            this.branch(model.branch);
            this.secretArn(model.secretArn);
        }

        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public final void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Override
        public final Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public GitConfig build() {
            return new GitConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitConfig> {
        public Builder repositoryUrl(String var1);

        public Builder branch(String var1);

        public Builder secretArn(String var1);
    }
}

