/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesError;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesErrorListCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteClusterNodesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, BatchDeleteClusterNodesResponse> {
    private static final SdkField<List<BatchDeleteClusterNodesError>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(BatchDeleteClusterNodesResponse.getter(BatchDeleteClusterNodesResponse::failed)).setter(BatchDeleteClusterNodesResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteClusterNodesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(BatchDeleteClusterNodesResponse.getter(BatchDeleteClusterNodesResponse::successful)).setter(BatchDeleteClusterNodesResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, SUCCESSFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteClusterNodesResponse.memberNameToFieldInitializer();
    private final List<BatchDeleteClusterNodesError> failed;
    private final List<String> successful;

    private BatchDeleteClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.successful = builder.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteClusterNodesError> failed() {
        return this.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<String> successful() {
        return this.successful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterNodesResponse)) {
            return false;
        }
        BatchDeleteClusterNodesResponse other = (BatchDeleteClusterNodesResponse)((Object)obj);
        return this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed()) && this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteClusterNodesResponse").add("Failed", this.hasFailed() ? this.failed() : null).add("Successful", this.hasSuccessful() ? this.successful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Failed", FAILED_FIELD);
        map.put("Successful", SUCCESSFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterNodesResponse, T> g) {
        return obj -> g.apply((BatchDeleteClusterNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteClusterNodesError> failed = DefaultSdkAutoConstructList.getInstance();
        private List<String> successful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterNodesResponse model) {
            super(model);
            this.failed(model.failed);
            this.successful(model.successful);
        }

        public final List<BatchDeleteClusterNodesError.Builder> getFailed() {
            List<BatchDeleteClusterNodesError.Builder> result = BatchDeleteClusterNodesErrorListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchDeleteClusterNodesError.BuilderImpl> failed) {
            this.failed = BatchDeleteClusterNodesErrorListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchDeleteClusterNodesError> failed) {
            this.failed = BatchDeleteClusterNodesErrorListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchDeleteClusterNodesError ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchDeleteClusterNodesError.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchDeleteClusterNodesError)((BatchDeleteClusterNodesError.Builder)BatchDeleteClusterNodesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSuccessful() {
            if (this.successful instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successful;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        public BatchDeleteClusterNodesResponse build() {
            return new BatchDeleteClusterNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteClusterNodesResponse> {
        public Builder failed(Collection<BatchDeleteClusterNodesError> var1);

        public Builder failed(BatchDeleteClusterNodesError ... var1);

        public Builder failed(Consumer<BatchDeleteClusterNodesError.Builder> ... var1);

        public Builder successful(Collection<String> var1);

        public Builder successful(String ... var1);
    }
}

