/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelRegisterSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelRegisterSettings> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelRegisterSettings.getter(ModelRegisterSettings::statusAsString)).setter(ModelRegisterSettings.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CROSS_ACCOUNT_MODEL_REGISTER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrossAccountModelRegisterRoleArn").getter(ModelRegisterSettings.getter(ModelRegisterSettings::crossAccountModelRegisterRoleArn)).setter(ModelRegisterSettings.setter(Builder::crossAccountModelRegisterRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountModelRegisterRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CROSS_ACCOUNT_MODEL_REGISTER_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelRegisterSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String crossAccountModelRegisterRoleArn;

    private ModelRegisterSettings(BuilderImpl builder) {
        this.status = builder.status;
        this.crossAccountModelRegisterRoleArn = builder.crossAccountModelRegisterRoleArn;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String crossAccountModelRegisterRoleArn() {
        return this.crossAccountModelRegisterRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountModelRegisterRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelRegisterSettings)) {
            return false;
        }
        ModelRegisterSettings other = (ModelRegisterSettings)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.crossAccountModelRegisterRoleArn(), other.crossAccountModelRegisterRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ModelRegisterSettings").add("Status", (Object)this.statusAsString()).add("CrossAccountModelRegisterRoleArn", (Object)this.crossAccountModelRegisterRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CrossAccountModelRegisterRoleArn": {
                return Optional.ofNullable(clazz.cast(this.crossAccountModelRegisterRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Status", STATUS_FIELD);
        map.put("CrossAccountModelRegisterRoleArn", CROSS_ACCOUNT_MODEL_REGISTER_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelRegisterSettings, T> g) {
        return obj -> g.apply((ModelRegisterSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String crossAccountModelRegisterRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelRegisterSettings model) {
            this.status(model.status);
            this.crossAccountModelRegisterRoleArn(model.crossAccountModelRegisterRoleArn);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCrossAccountModelRegisterRoleArn() {
            return this.crossAccountModelRegisterRoleArn;
        }

        public final void setCrossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn) {
            this.crossAccountModelRegisterRoleArn = crossAccountModelRegisterRoleArn;
        }

        @Override
        public final Builder crossAccountModelRegisterRoleArn(String crossAccountModelRegisterRoleArn) {
            this.crossAccountModelRegisterRoleArn = crossAccountModelRegisterRoleArn;
            return this;
        }

        public ModelRegisterSettings build() {
            return new ModelRegisterSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelRegisterSettings> {
        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder crossAccountModelRegisterRoleArn(String var1);
    }
}

