/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;

public class SearchPublisher
implements SdkPublisher<SearchResponse> {
    private final SageMakerAsyncClient client;
    private final SearchRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchPublisher(SageMakerAsyncClient client, SearchRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchPublisher(SageMakerAsyncClient client, SearchRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final SearchPublisher resume(SearchResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchPublisher(this.client, (SearchRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new SearchPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super SearchResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class SearchResponseFetcher
    implements AsyncPageFetcher<SearchResponse> {
        private SearchResponseFetcher() {
        }

        public boolean hasNextPage(SearchResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchResponse> nextPage(SearchResponse previousPage) {
            if (previousPage == null) {
                return SearchPublisher.this.client.search(SearchPublisher.this.firstRequest);
            }
            return SearchPublisher.this.client.search((SearchRequest)((Object)SearchPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

