/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentComputeResourceRequirements;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentContainerSpecification;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentStartupParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentSpecification> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(InferenceComponentSpecification.getter(InferenceComponentSpecification::modelName)).setter(InferenceComponentSpecification.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<InferenceComponentContainerSpecification> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Container").getter(InferenceComponentSpecification.getter(InferenceComponentSpecification::container)).setter(InferenceComponentSpecification.setter(Builder::container)).constructor(InferenceComponentContainerSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<InferenceComponentStartupParameters> STARTUP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartupParameters").getter(InferenceComponentSpecification.getter(InferenceComponentSpecification::startupParameters)).setter(InferenceComponentSpecification.setter(Builder::startupParameters)).constructor(InferenceComponentStartupParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupParameters").build()}).build();
    private static final SdkField<InferenceComponentComputeResourceRequirements> COMPUTE_RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeResourceRequirements").getter(InferenceComponentSpecification.getter(InferenceComponentSpecification::computeResourceRequirements)).setter(InferenceComponentSpecification.setter(Builder::computeResourceRequirements)).constructor(InferenceComponentComputeResourceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeResourceRequirements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, CONTAINER_FIELD, STARTUP_PARAMETERS_FIELD, COMPUTE_RESOURCE_REQUIREMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelName", MODEL_NAME_FIELD);
            this.put("Container", CONTAINER_FIELD);
            this.put("StartupParameters", STARTUP_PARAMETERS_FIELD);
            this.put("ComputeResourceRequirements", COMPUTE_RESOURCE_REQUIREMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final InferenceComponentContainerSpecification container;
    private final InferenceComponentStartupParameters startupParameters;
    private final InferenceComponentComputeResourceRequirements computeResourceRequirements;

    private InferenceComponentSpecification(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.container = builder.container;
        this.startupParameters = builder.startupParameters;
        this.computeResourceRequirements = builder.computeResourceRequirements;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final InferenceComponentContainerSpecification container() {
        return this.container;
    }

    public final InferenceComponentStartupParameters startupParameters() {
        return this.startupParameters;
    }

    public final InferenceComponentComputeResourceRequirements computeResourceRequirements() {
        return this.computeResourceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResourceRequirements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentSpecification)) {
            return false;
        }
        InferenceComponentSpecification other = (InferenceComponentSpecification)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.startupParameters(), other.startupParameters()) && Objects.equals(this.computeResourceRequirements(), other.computeResourceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentSpecification").add("ModelName", (Object)this.modelName()).add("Container", (Object)this.container()).add("StartupParameters", (Object)this.startupParameters()).add("ComputeResourceRequirements", (Object)this.computeResourceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "StartupParameters": {
                return Optional.ofNullable(clazz.cast(this.startupParameters()));
            }
            case "ComputeResourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.computeResourceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentSpecification, T> g) {
        return obj -> g.apply((InferenceComponentSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private InferenceComponentContainerSpecification container;
        private InferenceComponentStartupParameters startupParameters;
        private InferenceComponentComputeResourceRequirements computeResourceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentSpecification model) {
            this.modelName(model.modelName);
            this.container(model.container);
            this.startupParameters(model.startupParameters);
            this.computeResourceRequirements(model.computeResourceRequirements);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final InferenceComponentContainerSpecification.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(InferenceComponentContainerSpecification.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(InferenceComponentContainerSpecification container) {
            this.container = container;
            return this;
        }

        public final InferenceComponentStartupParameters.Builder getStartupParameters() {
            return this.startupParameters != null ? this.startupParameters.toBuilder() : null;
        }

        public final void setStartupParameters(InferenceComponentStartupParameters.BuilderImpl startupParameters) {
            this.startupParameters = startupParameters != null ? startupParameters.build() : null;
        }

        @Override
        public final Builder startupParameters(InferenceComponentStartupParameters startupParameters) {
            this.startupParameters = startupParameters;
            return this;
        }

        public final InferenceComponentComputeResourceRequirements.Builder getComputeResourceRequirements() {
            return this.computeResourceRequirements != null ? this.computeResourceRequirements.toBuilder() : null;
        }

        public final void setComputeResourceRequirements(InferenceComponentComputeResourceRequirements.BuilderImpl computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements != null ? computeResourceRequirements.build() : null;
        }

        @Override
        public final Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements;
            return this;
        }

        public InferenceComponentSpecification build() {
            return new InferenceComponentSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentSpecification> {
        public Builder modelName(String var1);

        public Builder container(InferenceComponentContainerSpecification var1);

        default public Builder container(Consumer<InferenceComponentContainerSpecification.Builder> container) {
            return this.container((InferenceComponentContainerSpecification)((InferenceComponentContainerSpecification.Builder)InferenceComponentContainerSpecification.builder().applyMutation(container)).build());
        }

        public Builder startupParameters(InferenceComponentStartupParameters var1);

        default public Builder startupParameters(Consumer<InferenceComponentStartupParameters.Builder> startupParameters) {
            return this.startupParameters((InferenceComponentStartupParameters)((InferenceComponentStartupParameters.Builder)InferenceComponentStartupParameters.builder().applyMutation(startupParameters)).build());
        }

        public Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements var1);

        default public Builder computeResourceRequirements(Consumer<InferenceComponentComputeResourceRequirements.Builder> computeResourceRequirements) {
            return this.computeResourceRequirements((InferenceComponentComputeResourceRequirements)((InferenceComponentComputeResourceRequirements.Builder)InferenceComponentComputeResourceRequirements.builder().applyMutation(computeResourceRequirements)).build());
        }
    }
}

