/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComputeQuotaResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, UpdateComputeQuotaResponse> {
    private static final SdkField<String> COMPUTE_QUOTA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaArn").getter(UpdateComputeQuotaResponse.getter(UpdateComputeQuotaResponse::computeQuotaArn)).setter(UpdateComputeQuotaResponse.setter(Builder::computeQuotaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaArn").build()}).build();
    private static final SdkField<Integer> COMPUTE_QUOTA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ComputeQuotaVersion").getter(UpdateComputeQuotaResponse.getter(UpdateComputeQuotaResponse::computeQuotaVersion)).setter(UpdateComputeQuotaResponse.setter(Builder::computeQuotaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ARN_FIELD, COMPUTE_QUOTA_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateComputeQuotaResponse.memberNameToFieldInitializer();
    private final String computeQuotaArn;
    private final Integer computeQuotaVersion;

    private UpdateComputeQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.computeQuotaArn = builder.computeQuotaArn;
        this.computeQuotaVersion = builder.computeQuotaVersion;
    }

    public final String computeQuotaArn() {
        return this.computeQuotaArn;
    }

    public final Integer computeQuotaVersion() {
        return this.computeQuotaVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeQuotaResponse)) {
            return false;
        }
        UpdateComputeQuotaResponse other = (UpdateComputeQuotaResponse)((Object)obj);
        return Objects.equals(this.computeQuotaArn(), other.computeQuotaArn()) && Objects.equals(this.computeQuotaVersion(), other.computeQuotaVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComputeQuotaResponse").add("ComputeQuotaArn", (Object)this.computeQuotaArn()).add("ComputeQuotaVersion", (Object)this.computeQuotaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaArn": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaArn()));
            }
            case "ComputeQuotaVersion": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComputeQuotaArn", COMPUTE_QUOTA_ARN_FIELD);
        map.put("ComputeQuotaVersion", COMPUTE_QUOTA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeQuotaResponse, T> g) {
        return obj -> g.apply((UpdateComputeQuotaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String computeQuotaArn;
        private Integer computeQuotaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeQuotaResponse model) {
            super(model);
            this.computeQuotaArn(model.computeQuotaArn);
            this.computeQuotaVersion(model.computeQuotaVersion);
        }

        public final String getComputeQuotaArn() {
            return this.computeQuotaArn;
        }

        public final void setComputeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
        }

        @Override
        public final Builder computeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
            return this;
        }

        public final Integer getComputeQuotaVersion() {
            return this.computeQuotaVersion;
        }

        public final void setComputeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
        }

        @Override
        public final Builder computeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
            return this;
        }

        @Override
        public UpdateComputeQuotaResponse build() {
            return new UpdateComputeQuotaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComputeQuotaResponse> {
        public Builder computeQuotaArn(String var1);

        public Builder computeQuotaVersion(Integer var1);
    }
}

