/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingRepositoryAccessMode {
    PLATFORM("Platform"),
    VPC("Vpc"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingRepositoryAccessMode> VALUE_MAP;
    private final String value;

    private TrainingRepositoryAccessMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingRepositoryAccessMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingRepositoryAccessMode> knownValues() {
        EnumSet<TrainingRepositoryAccessMode> knownValues = EnumSet.allOf(TrainingRepositoryAccessMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingRepositoryAccessMode.class, TrainingRepositoryAccessMode::toString);
    }
}

