/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceLimits> {
    private static final SdkField<Integer> MAX_NUMBER_OF_TRAINING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxNumberOfTrainingJobs").getter(ResourceLimits.getter(ResourceLimits::maxNumberOfTrainingJobs)).setter(ResourceLimits.setter(Builder::maxNumberOfTrainingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxNumberOfTrainingJobs").build()}).build();
    private static final SdkField<Integer> MAX_PARALLEL_TRAINING_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxParallelTrainingJobs").getter(ResourceLimits.getter(ResourceLimits::maxParallelTrainingJobs)).setter(ResourceLimits.setter(Builder::maxParallelTrainingJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelTrainingJobs").build()}).build();
    private static final SdkField<Integer> MAX_RUNTIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRuntimeInSeconds").getter(ResourceLimits.getter(ResourceLimits::maxRuntimeInSeconds)).setter(ResourceLimits.setter(Builder::maxRuntimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRuntimeInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_NUMBER_OF_TRAINING_JOBS_FIELD, MAX_PARALLEL_TRAINING_JOBS_FIELD, MAX_RUNTIME_IN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceLimits.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxNumberOfTrainingJobs;
    private final Integer maxParallelTrainingJobs;
    private final Integer maxRuntimeInSeconds;

    private ResourceLimits(BuilderImpl builder) {
        this.maxNumberOfTrainingJobs = builder.maxNumberOfTrainingJobs;
        this.maxParallelTrainingJobs = builder.maxParallelTrainingJobs;
        this.maxRuntimeInSeconds = builder.maxRuntimeInSeconds;
    }

    public final Integer maxNumberOfTrainingJobs() {
        return this.maxNumberOfTrainingJobs;
    }

    public final Integer maxParallelTrainingJobs() {
        return this.maxParallelTrainingJobs;
    }

    public final Integer maxRuntimeInSeconds() {
        return this.maxRuntimeInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNumberOfTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelTrainingJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRuntimeInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceLimits)) {
            return false;
        }
        ResourceLimits other = (ResourceLimits)obj;
        return Objects.equals(this.maxNumberOfTrainingJobs(), other.maxNumberOfTrainingJobs()) && Objects.equals(this.maxParallelTrainingJobs(), other.maxParallelTrainingJobs()) && Objects.equals(this.maxRuntimeInSeconds(), other.maxRuntimeInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceLimits").add("MaxNumberOfTrainingJobs", (Object)this.maxNumberOfTrainingJobs()).add("MaxParallelTrainingJobs", (Object)this.maxParallelTrainingJobs()).add("MaxRuntimeInSeconds", (Object)this.maxRuntimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxNumberOfTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxNumberOfTrainingJobs()));
            }
            case "MaxParallelTrainingJobs": {
                return Optional.ofNullable(clazz.cast(this.maxParallelTrainingJobs()));
            }
            case "MaxRuntimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxRuntimeInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("MaxNumberOfTrainingJobs", MAX_NUMBER_OF_TRAINING_JOBS_FIELD);
        map.put("MaxParallelTrainingJobs", MAX_PARALLEL_TRAINING_JOBS_FIELD);
        map.put("MaxRuntimeInSeconds", MAX_RUNTIME_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceLimits, T> g) {
        return obj -> g.apply((ResourceLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxNumberOfTrainingJobs;
        private Integer maxParallelTrainingJobs;
        private Integer maxRuntimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceLimits model) {
            this.maxNumberOfTrainingJobs(model.maxNumberOfTrainingJobs);
            this.maxParallelTrainingJobs(model.maxParallelTrainingJobs);
            this.maxRuntimeInSeconds(model.maxRuntimeInSeconds);
        }

        public final Integer getMaxNumberOfTrainingJobs() {
            return this.maxNumberOfTrainingJobs;
        }

        public final void setMaxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
        }

        @Override
        public final Builder maxNumberOfTrainingJobs(Integer maxNumberOfTrainingJobs) {
            this.maxNumberOfTrainingJobs = maxNumberOfTrainingJobs;
            return this;
        }

        public final Integer getMaxParallelTrainingJobs() {
            return this.maxParallelTrainingJobs;
        }

        public final void setMaxParallelTrainingJobs(Integer maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
        }

        @Override
        public final Builder maxParallelTrainingJobs(Integer maxParallelTrainingJobs) {
            this.maxParallelTrainingJobs = maxParallelTrainingJobs;
            return this;
        }

        public final Integer getMaxRuntimeInSeconds() {
            return this.maxRuntimeInSeconds;
        }

        public final void setMaxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
            this.maxRuntimeInSeconds = maxRuntimeInSeconds;
        }

        @Override
        public final Builder maxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
            this.maxRuntimeInSeconds = maxRuntimeInSeconds;
            return this;
        }

        public ResourceLimits build() {
            return new ResourceLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceLimits> {
        public Builder maxNumberOfTrainingJobs(Integer var1);

        public Builder maxParallelTrainingJobs(Integer var1);

        public Builder maxRuntimeInSeconds(Integer var1);
    }
}

