/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceGroupStatus {
    IN_SERVICE("InService"),
    CREATING("Creating"),
    UPDATING("Updating"),
    FAILED("Failed"),
    DEGRADED("Degraded"),
    SYSTEM_UPDATING("SystemUpdating"),
    DELETING("Deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceGroupStatus> VALUE_MAP;
    private final String value;

    private InstanceGroupStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceGroupStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceGroupStatus> knownValues() {
        EnumSet<InstanceGroupStatus> knownValues = EnumSet.allOf(InstanceGroupStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceGroupStatus.class, InstanceGroupStatus::toString);
    }
}

