/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UiTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHumanTaskUiRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateHumanTaskUiRequest> {
    private static final SdkField<String> HUMAN_TASK_UI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanTaskUiName").getter(CreateHumanTaskUiRequest.getter(CreateHumanTaskUiRequest::humanTaskUiName)).setter(CreateHumanTaskUiRequest.setter(Builder::humanTaskUiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiName").build()}).build();
    private static final SdkField<UiTemplate> UI_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UiTemplate").getter(CreateHumanTaskUiRequest.getter(CreateHumanTaskUiRequest::uiTemplate)).setter(CreateHumanTaskUiRequest.setter(Builder::uiTemplate)).constructor(UiTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateHumanTaskUiRequest.getter(CreateHumanTaskUiRequest::tags)).setter(CreateHumanTaskUiRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_NAME_FIELD, UI_TEMPLATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateHumanTaskUiRequest.memberNameToFieldInitializer();
    private final String humanTaskUiName;
    private final UiTemplate uiTemplate;
    private final List<Tag> tags;

    private CreateHumanTaskUiRequest(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiName = builder.humanTaskUiName;
        this.uiTemplate = builder.uiTemplate;
        this.tags = builder.tags;
    }

    public final String humanTaskUiName() {
        return this.humanTaskUiName;
    }

    public final UiTemplate uiTemplate() {
        return this.uiTemplate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskUiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uiTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHumanTaskUiRequest)) {
            return false;
        }
        CreateHumanTaskUiRequest other = (CreateHumanTaskUiRequest)((Object)obj);
        return Objects.equals(this.humanTaskUiName(), other.humanTaskUiName()) && Objects.equals(this.uiTemplate(), other.uiTemplate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHumanTaskUiRequest").add("HumanTaskUiName", (Object)this.humanTaskUiName()).add("UiTemplate", (Object)this.uiTemplate()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanTaskUiName": {
                return Optional.ofNullable(clazz.cast(this.humanTaskUiName()));
            }
            case "UiTemplate": {
                return Optional.ofNullable(clazz.cast(this.uiTemplate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HumanTaskUiName", HUMAN_TASK_UI_NAME_FIELD);
        map.put("UiTemplate", UI_TEMPLATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHumanTaskUiRequest, T> g) {
        return obj -> g.apply((CreateHumanTaskUiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String humanTaskUiName;
        private UiTemplate uiTemplate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHumanTaskUiRequest model) {
            super(model);
            this.humanTaskUiName(model.humanTaskUiName);
            this.uiTemplate(model.uiTemplate);
            this.tags(model.tags);
        }

        public final String getHumanTaskUiName() {
            return this.humanTaskUiName;
        }

        public final void setHumanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
        }

        @Override
        public final Builder humanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
            return this;
        }

        public final UiTemplate.Builder getUiTemplate() {
            return this.uiTemplate != null ? this.uiTemplate.toBuilder() : null;
        }

        public final void setUiTemplate(UiTemplate.BuilderImpl uiTemplate) {
            this.uiTemplate = uiTemplate != null ? uiTemplate.build() : null;
        }

        @Override
        public final Builder uiTemplate(UiTemplate uiTemplate) {
            this.uiTemplate = uiTemplate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHumanTaskUiRequest build() {
            return new CreateHumanTaskUiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHumanTaskUiRequest> {
        public Builder humanTaskUiName(String var1);

        public Builder uiTemplate(UiTemplate var1);

        default public Builder uiTemplate(Consumer<UiTemplate.Builder> uiTemplate) {
            return this.uiTemplate((UiTemplate)((UiTemplate.Builder)UiTemplate.builder().applyMutation(uiTemplate)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

