/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig;
import software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig;
import software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowDefinitionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateFlowDefinitionRequest> {
    private static final SdkField<String> FLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionName").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::flowDefinitionName)).setter(CreateFlowDefinitionRequest.setter(Builder::flowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionName").build()}).build();
    private static final SdkField<HumanLoopRequestSource> HUMAN_LOOP_REQUEST_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopRequestSource").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::humanLoopRequestSource)).setter(CreateFlowDefinitionRequest.setter(Builder::humanLoopRequestSource)).constructor(HumanLoopRequestSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopRequestSource").build()}).build();
    private static final SdkField<HumanLoopActivationConfig> HUMAN_LOOP_ACTIVATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopActivationConfig").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::humanLoopActivationConfig)).setter(CreateFlowDefinitionRequest.setter(Builder::humanLoopActivationConfig)).constructor(HumanLoopActivationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationConfig").build()}).build();
    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopConfig").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::humanLoopConfig)).setter(CreateFlowDefinitionRequest.setter(Builder::humanLoopConfig)).constructor(HumanLoopConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()}).build();
    private static final SdkField<FlowDefinitionOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::outputConfig)).setter(CreateFlowDefinitionRequest.setter(Builder::outputConfig)).constructor(FlowDefinitionOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::roleArn)).setter(CreateFlowDefinitionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFlowDefinitionRequest.getter(CreateFlowDefinitionRequest::tags)).setter(CreateFlowDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_NAME_FIELD, HUMAN_LOOP_REQUEST_SOURCE_FIELD, HUMAN_LOOP_ACTIVATION_CONFIG_FIELD, HUMAN_LOOP_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFlowDefinitionRequest.memberNameToFieldInitializer();
    private final String flowDefinitionName;
    private final HumanLoopRequestSource humanLoopRequestSource;
    private final HumanLoopActivationConfig humanLoopActivationConfig;
    private final HumanLoopConfig humanLoopConfig;
    private final FlowDefinitionOutputConfig outputConfig;
    private final String roleArn;
    private final List<Tag> tags;

    private CreateFlowDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.flowDefinitionName = builder.flowDefinitionName;
        this.humanLoopRequestSource = builder.humanLoopRequestSource;
        this.humanLoopActivationConfig = builder.humanLoopActivationConfig;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String flowDefinitionName() {
        return this.flowDefinitionName;
    }

    public final HumanLoopRequestSource humanLoopRequestSource() {
        return this.humanLoopRequestSource;
    }

    public final HumanLoopActivationConfig humanLoopActivationConfig() {
        return this.humanLoopActivationConfig;
    }

    public final HumanLoopConfig humanLoopConfig() {
        return this.humanLoopConfig;
    }

    public final FlowDefinitionOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopRequestSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopActivationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowDefinitionRequest)) {
            return false;
        }
        CreateFlowDefinitionRequest other = (CreateFlowDefinitionRequest)((Object)obj);
        return Objects.equals(this.flowDefinitionName(), other.flowDefinitionName()) && Objects.equals(this.humanLoopRequestSource(), other.humanLoopRequestSource()) && Objects.equals(this.humanLoopActivationConfig(), other.humanLoopActivationConfig()) && Objects.equals(this.humanLoopConfig(), other.humanLoopConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFlowDefinitionRequest").add("FlowDefinitionName", (Object)this.flowDefinitionName()).add("HumanLoopRequestSource", (Object)this.humanLoopRequestSource()).add("HumanLoopActivationConfig", (Object)this.humanLoopActivationConfig()).add("HumanLoopConfig", (Object)this.humanLoopConfig()).add("OutputConfig", (Object)this.outputConfig()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionName()));
            }
            case "HumanLoopRequestSource": {
                return Optional.ofNullable(clazz.cast(this.humanLoopRequestSource()));
            }
            case "HumanLoopActivationConfig": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationConfig()));
            }
            case "HumanLoopConfig": {
                return Optional.ofNullable(clazz.cast(this.humanLoopConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlowDefinitionName", FLOW_DEFINITION_NAME_FIELD);
        map.put("HumanLoopRequestSource", HUMAN_LOOP_REQUEST_SOURCE_FIELD);
        map.put("HumanLoopActivationConfig", HUMAN_LOOP_ACTIVATION_CONFIG_FIELD);
        map.put("HumanLoopConfig", HUMAN_LOOP_CONFIG_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowDefinitionRequest, T> g) {
        return obj -> g.apply((CreateFlowDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String flowDefinitionName;
        private HumanLoopRequestSource humanLoopRequestSource;
        private HumanLoopActivationConfig humanLoopActivationConfig;
        private HumanLoopConfig humanLoopConfig;
        private FlowDefinitionOutputConfig outputConfig;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowDefinitionRequest model) {
            super(model);
            this.flowDefinitionName(model.flowDefinitionName);
            this.humanLoopRequestSource(model.humanLoopRequestSource);
            this.humanLoopActivationConfig(model.humanLoopActivationConfig);
            this.humanLoopConfig(model.humanLoopConfig);
            this.outputConfig(model.outputConfig);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getFlowDefinitionName() {
            return this.flowDefinitionName;
        }

        public final void setFlowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
        }

        @Override
        public final Builder flowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
            return this;
        }

        public final HumanLoopRequestSource.Builder getHumanLoopRequestSource() {
            return this.humanLoopRequestSource != null ? this.humanLoopRequestSource.toBuilder() : null;
        }

        public final void setHumanLoopRequestSource(HumanLoopRequestSource.BuilderImpl humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource != null ? humanLoopRequestSource.build() : null;
        }

        @Override
        public final Builder humanLoopRequestSource(HumanLoopRequestSource humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource;
            return this;
        }

        public final HumanLoopActivationConfig.Builder getHumanLoopActivationConfig() {
            return this.humanLoopActivationConfig != null ? this.humanLoopActivationConfig.toBuilder() : null;
        }

        public final void setHumanLoopActivationConfig(HumanLoopActivationConfig.BuilderImpl humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig != null ? humanLoopActivationConfig.build() : null;
        }

        @Override
        public final Builder humanLoopActivationConfig(HumanLoopActivationConfig humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig;
            return this;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return this.humanLoopConfig != null ? this.humanLoopConfig.toBuilder() : null;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        @Override
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final FlowDefinitionOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(FlowDefinitionOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(FlowDefinitionOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowDefinitionRequest build() {
            return new CreateFlowDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowDefinitionRequest> {
        public Builder flowDefinitionName(String var1);

        public Builder humanLoopRequestSource(HumanLoopRequestSource var1);

        default public Builder humanLoopRequestSource(Consumer<HumanLoopRequestSource.Builder> humanLoopRequestSource) {
            return this.humanLoopRequestSource((HumanLoopRequestSource)((HumanLoopRequestSource.Builder)HumanLoopRequestSource.builder().applyMutation(humanLoopRequestSource)).build());
        }

        public Builder humanLoopActivationConfig(HumanLoopActivationConfig var1);

        default public Builder humanLoopActivationConfig(Consumer<HumanLoopActivationConfig.Builder> humanLoopActivationConfig) {
            return this.humanLoopActivationConfig((HumanLoopActivationConfig)((HumanLoopActivationConfig.Builder)HumanLoopActivationConfig.builder().applyMutation(humanLoopActivationConfig)).build());
        }

        public Builder humanLoopConfig(HumanLoopConfig var1);

        default public Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return this.humanLoopConfig((HumanLoopConfig)((HumanLoopConfig.Builder)HumanLoopConfig.builder().applyMutation(humanLoopConfig)).build());
        }

        public Builder outputConfig(FlowDefinitionOutputConfig var1);

        default public Builder outputConfig(Consumer<FlowDefinitionOutputConfig.Builder> outputConfig) {
            return this.outputConfig((FlowDefinitionOutputConfig)((FlowDefinitionOutputConfig.Builder)FlowDefinitionOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

