/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CompressionType;
import software.amazon.awssdk.services.sagemaker.model.CompressionTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.ContentTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.InputModesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingInputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelSpecification> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ChannelSpecification.getter(ChannelSpecification::name)).setter(ChannelSpecification.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ChannelSpecification.getter(ChannelSpecification::description)).setter(ChannelSpecification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRequired").getter(ChannelSpecification.getter(ChannelSpecification::isRequired)).setter(ChannelSpecification.setter(Builder::isRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRequired").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedContentTypes").getter(ChannelSpecification.getter(ChannelSpecification::supportedContentTypes)).setter(ChannelSpecification.setter(Builder::supportedContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_COMPRESSION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedCompressionTypes").getter(ChannelSpecification.getter(ChannelSpecification::supportedCompressionTypesAsStrings)).setter(ChannelSpecification.setter(Builder::supportedCompressionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedCompressionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_INPUT_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedInputModes").getter(ChannelSpecification.getter(ChannelSpecification::supportedInputModesAsStrings)).setter(ChannelSpecification.setter(Builder::supportedInputModesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedInputModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, IS_REQUIRED_FIELD, SUPPORTED_CONTENT_TYPES_FIELD, SUPPORTED_COMPRESSION_TYPES_FIELD, SUPPORTED_INPUT_MODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Boolean isRequired;
    private final List<String> supportedContentTypes;
    private final List<String> supportedCompressionTypes;
    private final List<String> supportedInputModes;

    private ChannelSpecification(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.isRequired = builder.isRequired;
        this.supportedContentTypes = builder.supportedContentTypes;
        this.supportedCompressionTypes = builder.supportedCompressionTypes;
        this.supportedInputModes = builder.supportedInputModes;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isRequired() {
        return this.isRequired;
    }

    public final boolean hasSupportedContentTypes() {
        return this.supportedContentTypes != null && !(this.supportedContentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedContentTypes() {
        return this.supportedContentTypes;
    }

    public final List<CompressionType> supportedCompressionTypes() {
        return CompressionTypesCopier.copyStringToEnum(this.supportedCompressionTypes);
    }

    public final boolean hasSupportedCompressionTypes() {
        return this.supportedCompressionTypes != null && !(this.supportedCompressionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedCompressionTypesAsStrings() {
        return this.supportedCompressionTypes;
    }

    public final List<TrainingInputMode> supportedInputModes() {
        return InputModesCopier.copyStringToEnum(this.supportedInputModes);
    }

    public final boolean hasSupportedInputModes() {
        return this.supportedInputModes != null && !(this.supportedInputModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedInputModesAsStrings() {
        return this.supportedInputModes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedContentTypes() ? this.supportedContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedCompressionTypes() ? this.supportedCompressionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedInputModes() ? this.supportedInputModesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSpecification)) {
            return false;
        }
        ChannelSpecification other = (ChannelSpecification)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isRequired(), other.isRequired()) && this.hasSupportedContentTypes() == other.hasSupportedContentTypes() && Objects.equals(this.supportedContentTypes(), other.supportedContentTypes()) && this.hasSupportedCompressionTypes() == other.hasSupportedCompressionTypes() && Objects.equals(this.supportedCompressionTypesAsStrings(), other.supportedCompressionTypesAsStrings()) && this.hasSupportedInputModes() == other.hasSupportedInputModes() && Objects.equals(this.supportedInputModesAsStrings(), other.supportedInputModesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelSpecification").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("IsRequired", (Object)this.isRequired()).add("SupportedContentTypes", this.hasSupportedContentTypes() ? this.supportedContentTypes() : null).add("SupportedCompressionTypes", this.hasSupportedCompressionTypes() ? this.supportedCompressionTypesAsStrings() : null).add("SupportedInputModes", this.hasSupportedInputModes() ? this.supportedInputModesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IsRequired": {
                return Optional.ofNullable(clazz.cast(this.isRequired()));
            }
            case "SupportedContentTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedContentTypes()));
            }
            case "SupportedCompressionTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedCompressionTypesAsStrings()));
            }
            case "SupportedInputModes": {
                return Optional.ofNullable(clazz.cast(this.supportedInputModesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IsRequired", IS_REQUIRED_FIELD);
        map.put("SupportedContentTypes", SUPPORTED_CONTENT_TYPES_FIELD);
        map.put("SupportedCompressionTypes", SUPPORTED_COMPRESSION_TYPES_FIELD);
        map.put("SupportedInputModes", SUPPORTED_INPUT_MODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelSpecification, T> g) {
        return obj -> g.apply((ChannelSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Boolean isRequired;
        private List<String> supportedContentTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedCompressionTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedInputModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSpecification model) {
            this.name(model.name);
            this.description(model.description);
            this.isRequired(model.isRequired);
            this.supportedContentTypes(model.supportedContentTypes);
            this.supportedCompressionTypesWithStrings(model.supportedCompressionTypes);
            this.supportedInputModesWithStrings(model.supportedInputModes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsRequired() {
            return this.isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final Collection<String> getSupportedContentTypes() {
            if (this.supportedContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedContentTypes;
        }

        public final void setSupportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
        }

        @Override
        public final Builder supportedContentTypes(Collection<String> supportedContentTypes) {
            this.supportedContentTypes = ContentTypesCopier.copy(supportedContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedContentTypes(String ... supportedContentTypes) {
            this.supportedContentTypes(Arrays.asList(supportedContentTypes));
            return this;
        }

        public final Collection<String> getSupportedCompressionTypes() {
            if (this.supportedCompressionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedCompressionTypes;
        }

        public final void setSupportedCompressionTypes(Collection<String> supportedCompressionTypes) {
            this.supportedCompressionTypes = CompressionTypesCopier.copy(supportedCompressionTypes);
        }

        @Override
        public final Builder supportedCompressionTypesWithStrings(Collection<String> supportedCompressionTypes) {
            this.supportedCompressionTypes = CompressionTypesCopier.copy(supportedCompressionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCompressionTypesWithStrings(String ... supportedCompressionTypes) {
            this.supportedCompressionTypesWithStrings(Arrays.asList(supportedCompressionTypes));
            return this;
        }

        @Override
        public final Builder supportedCompressionTypes(Collection<CompressionType> supportedCompressionTypes) {
            this.supportedCompressionTypes = CompressionTypesCopier.copyEnumToString(supportedCompressionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCompressionTypes(CompressionType ... supportedCompressionTypes) {
            this.supportedCompressionTypes(Arrays.asList(supportedCompressionTypes));
            return this;
        }

        public final Collection<String> getSupportedInputModes() {
            if (this.supportedInputModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedInputModes;
        }

        public final void setSupportedInputModes(Collection<String> supportedInputModes) {
            this.supportedInputModes = InputModesCopier.copy(supportedInputModes);
        }

        @Override
        public final Builder supportedInputModesWithStrings(Collection<String> supportedInputModes) {
            this.supportedInputModes = InputModesCopier.copy(supportedInputModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInputModesWithStrings(String ... supportedInputModes) {
            this.supportedInputModesWithStrings(Arrays.asList(supportedInputModes));
            return this;
        }

        @Override
        public final Builder supportedInputModes(Collection<TrainingInputMode> supportedInputModes) {
            this.supportedInputModes = InputModesCopier.copyEnumToString(supportedInputModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInputModes(TrainingInputMode ... supportedInputModes) {
            this.supportedInputModes(Arrays.asList(supportedInputModes));
            return this;
        }

        public ChannelSpecification build() {
            return new ChannelSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelSpecification> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder isRequired(Boolean var1);

        public Builder supportedContentTypes(Collection<String> var1);

        public Builder supportedContentTypes(String ... var1);

        public Builder supportedCompressionTypesWithStrings(Collection<String> var1);

        public Builder supportedCompressionTypesWithStrings(String ... var1);

        public Builder supportedCompressionTypes(Collection<CompressionType> var1);

        public Builder supportedCompressionTypes(CompressionType ... var1);

        public Builder supportedInputModesWithStrings(Collection<String> var1);

        public Builder supportedInputModesWithStrings(String ... var1);

        public Builder supportedInputModes(Collection<TrainingInputMode> var1);

        public Builder supportedInputModes(TrainingInputMode ... var1);
    }
}

