/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmsConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CandidateGenerationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CandidateGenerationConfig> {
    private static final SdkField<List<AutoMLAlgorithmConfig>> ALGORITHMS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlgorithmsConfig").getter(CandidateGenerationConfig.getter(CandidateGenerationConfig::algorithmsConfig)).setter(CandidateGenerationConfig.setter(Builder::algorithmsConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmsConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoMLAlgorithmConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHMS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CandidateGenerationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AutoMLAlgorithmConfig> algorithmsConfig;

    private CandidateGenerationConfig(BuilderImpl builder) {
        this.algorithmsConfig = builder.algorithmsConfig;
    }

    public final boolean hasAlgorithmsConfig() {
        return this.algorithmsConfig != null && !(this.algorithmsConfig instanceof SdkAutoConstructList);
    }

    public final List<AutoMLAlgorithmConfig> algorithmsConfig() {
        return this.algorithmsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlgorithmsConfig() ? this.algorithmsConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateGenerationConfig)) {
            return false;
        }
        CandidateGenerationConfig other = (CandidateGenerationConfig)obj;
        return this.hasAlgorithmsConfig() == other.hasAlgorithmsConfig() && Objects.equals(this.algorithmsConfig(), other.algorithmsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CandidateGenerationConfig").add("AlgorithmsConfig", this.hasAlgorithmsConfig() ? this.algorithmsConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmsConfig": {
                return Optional.ofNullable(clazz.cast(this.algorithmsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<AutoMLAlgorithmConfig>>> map = new HashMap<String, SdkField<List<AutoMLAlgorithmConfig>>>();
        map.put("AlgorithmsConfig", ALGORITHMS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CandidateGenerationConfig, T> g) {
        return obj -> g.apply((CandidateGenerationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AutoMLAlgorithmConfig> algorithmsConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateGenerationConfig model) {
            this.algorithmsConfig(model.algorithmsConfig);
        }

        public final List<AutoMLAlgorithmConfig.Builder> getAlgorithmsConfig() {
            List<AutoMLAlgorithmConfig.Builder> result = AutoMLAlgorithmsConfigCopier.copyToBuilder(this.algorithmsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlgorithmsConfig(Collection<AutoMLAlgorithmConfig.BuilderImpl> algorithmsConfig) {
            this.algorithmsConfig = AutoMLAlgorithmsConfigCopier.copyFromBuilder(algorithmsConfig);
        }

        @Override
        public final Builder algorithmsConfig(Collection<AutoMLAlgorithmConfig> algorithmsConfig) {
            this.algorithmsConfig = AutoMLAlgorithmsConfigCopier.copy(algorithmsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmsConfig(AutoMLAlgorithmConfig ... algorithmsConfig) {
            this.algorithmsConfig(Arrays.asList(algorithmsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmsConfig(Consumer<AutoMLAlgorithmConfig.Builder> ... algorithmsConfig) {
            this.algorithmsConfig(Stream.of(algorithmsConfig).map(c -> (AutoMLAlgorithmConfig)((AutoMLAlgorithmConfig.Builder)AutoMLAlgorithmConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CandidateGenerationConfig build() {
            return new CandidateGenerationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CandidateGenerationConfig> {
        public Builder algorithmsConfig(Collection<AutoMLAlgorithmConfig> var1);

        public Builder algorithmsConfig(AutoMLAlgorithmConfig ... var1);

        public Builder algorithmsConfig(Consumer<AutoMLAlgorithmConfig.Builder> ... var1);
    }
}

