/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLJobObjectiveType {
    MAXIMIZE("Maximize"),
    MINIMIZE("Minimize"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLJobObjectiveType> VALUE_MAP;
    private final String value;

    private AutoMLJobObjectiveType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLJobObjectiveType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLJobObjectiveType> knownValues() {
        EnumSet<AutoMLJobObjectiveType> knownValues = EnumSet.allOf(AutoMLJobObjectiveType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLJobObjectiveType.class, AutoMLJobObjectiveType::toString);
    }
}

