/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeployedImage;
import software.amazon.awssdk.services.sagemaker.model.DeployedImagesCopier;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantManagedInstanceScaling;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantRoutingConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatus;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantSummary> {
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VariantName").getter(ProductionVariantSummary.getter(ProductionVariantSummary::variantName)).setter(ProductionVariantSummary.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<List<DeployedImage>> DEPLOYED_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeployedImages").getter(ProductionVariantSummary.getter(ProductionVariantSummary::deployedImages)).setter(ProductionVariantSummary.setter(Builder::deployedImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployedImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeployedImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> CURRENT_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("CurrentWeight").getter(ProductionVariantSummary.getter(ProductionVariantSummary::currentWeight)).setter(ProductionVariantSummary.setter(Builder::currentWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentWeight").build()}).build();
    private static final SdkField<Float> DESIRED_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("DesiredWeight").getter(ProductionVariantSummary.getter(ProductionVariantSummary::desiredWeight)).setter(ProductionVariantSummary.setter(Builder::desiredWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeight").build()}).build();
    private static final SdkField<Integer> CURRENT_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentInstanceCount").getter(ProductionVariantSummary.getter(ProductionVariantSummary::currentInstanceCount)).setter(ProductionVariantSummary.setter(Builder::currentInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstanceCount").build()}).build();
    private static final SdkField<Integer> DESIRED_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredInstanceCount").getter(ProductionVariantSummary.getter(ProductionVariantSummary::desiredInstanceCount)).setter(ProductionVariantSummary.setter(Builder::desiredInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstanceCount").build()}).build();
    private static final SdkField<List<ProductionVariantStatus>> VARIANT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VariantStatus").getter(ProductionVariantSummary.getter(ProductionVariantSummary::variantStatus)).setter(ProductionVariantSummary.setter(Builder::variantStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariantStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProductionVariantServerlessConfig> CURRENT_SERVERLESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentServerlessConfig").getter(ProductionVariantSummary.getter(ProductionVariantSummary::currentServerlessConfig)).setter(ProductionVariantSummary.setter(Builder::currentServerlessConfig)).constructor(ProductionVariantServerlessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentServerlessConfig").build()}).build();
    private static final SdkField<ProductionVariantServerlessConfig> DESIRED_SERVERLESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DesiredServerlessConfig").getter(ProductionVariantSummary.getter(ProductionVariantSummary::desiredServerlessConfig)).setter(ProductionVariantSummary.setter(Builder::desiredServerlessConfig)).constructor(ProductionVariantServerlessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredServerlessConfig").build()}).build();
    private static final SdkField<ProductionVariantManagedInstanceScaling> MANAGED_INSTANCE_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedInstanceScaling").getter(ProductionVariantSummary.getter(ProductionVariantSummary::managedInstanceScaling)).setter(ProductionVariantSummary.setter(Builder::managedInstanceScaling)).constructor(ProductionVariantManagedInstanceScaling::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedInstanceScaling").build()}).build();
    private static final SdkField<ProductionVariantRoutingConfig> ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingConfig").getter(ProductionVariantSummary.getter(ProductionVariantSummary::routingConfig)).setter(ProductionVariantSummary.setter(Builder::routingConfig)).constructor(ProductionVariantRoutingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_NAME_FIELD, DEPLOYED_IMAGES_FIELD, CURRENT_WEIGHT_FIELD, DESIRED_WEIGHT_FIELD, CURRENT_INSTANCE_COUNT_FIELD, DESIRED_INSTANCE_COUNT_FIELD, VARIANT_STATUS_FIELD, CURRENT_SERVERLESS_CONFIG_FIELD, DESIRED_SERVERLESS_CONFIG_FIELD, MANAGED_INSTANCE_SCALING_FIELD, ROUTING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductionVariantSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String variantName;
    private final List<DeployedImage> deployedImages;
    private final Float currentWeight;
    private final Float desiredWeight;
    private final Integer currentInstanceCount;
    private final Integer desiredInstanceCount;
    private final List<ProductionVariantStatus> variantStatus;
    private final ProductionVariantServerlessConfig currentServerlessConfig;
    private final ProductionVariantServerlessConfig desiredServerlessConfig;
    private final ProductionVariantManagedInstanceScaling managedInstanceScaling;
    private final ProductionVariantRoutingConfig routingConfig;

    private ProductionVariantSummary(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.deployedImages = builder.deployedImages;
        this.currentWeight = builder.currentWeight;
        this.desiredWeight = builder.desiredWeight;
        this.currentInstanceCount = builder.currentInstanceCount;
        this.desiredInstanceCount = builder.desiredInstanceCount;
        this.variantStatus = builder.variantStatus;
        this.currentServerlessConfig = builder.currentServerlessConfig;
        this.desiredServerlessConfig = builder.desiredServerlessConfig;
        this.managedInstanceScaling = builder.managedInstanceScaling;
        this.routingConfig = builder.routingConfig;
    }

    public final String variantName() {
        return this.variantName;
    }

    public final boolean hasDeployedImages() {
        return this.deployedImages != null && !(this.deployedImages instanceof SdkAutoConstructList);
    }

    public final List<DeployedImage> deployedImages() {
        return this.deployedImages;
    }

    public final Float currentWeight() {
        return this.currentWeight;
    }

    public final Float desiredWeight() {
        return this.desiredWeight;
    }

    public final Integer currentInstanceCount() {
        return this.currentInstanceCount;
    }

    public final Integer desiredInstanceCount() {
        return this.desiredInstanceCount;
    }

    public final boolean hasVariantStatus() {
        return this.variantStatus != null && !(this.variantStatus instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariantStatus> variantStatus() {
        return this.variantStatus;
    }

    public final ProductionVariantServerlessConfig currentServerlessConfig() {
        return this.currentServerlessConfig;
    }

    public final ProductionVariantServerlessConfig desiredServerlessConfig() {
        return this.desiredServerlessConfig;
    }

    public final ProductionVariantManagedInstanceScaling managedInstanceScaling() {
        return this.managedInstanceScaling;
    }

    public final ProductionVariantRoutingConfig routingConfig() {
        return this.routingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeployedImages() ? this.deployedImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariantStatus() ? this.variantStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentServerlessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredServerlessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedInstanceScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantSummary)) {
            return false;
        }
        ProductionVariantSummary other = (ProductionVariantSummary)obj;
        return Objects.equals(this.variantName(), other.variantName()) && this.hasDeployedImages() == other.hasDeployedImages() && Objects.equals(this.deployedImages(), other.deployedImages()) && Objects.equals(this.currentWeight(), other.currentWeight()) && Objects.equals(this.desiredWeight(), other.desiredWeight()) && Objects.equals(this.currentInstanceCount(), other.currentInstanceCount()) && Objects.equals(this.desiredInstanceCount(), other.desiredInstanceCount()) && this.hasVariantStatus() == other.hasVariantStatus() && Objects.equals(this.variantStatus(), other.variantStatus()) && Objects.equals(this.currentServerlessConfig(), other.currentServerlessConfig()) && Objects.equals(this.desiredServerlessConfig(), other.desiredServerlessConfig()) && Objects.equals(this.managedInstanceScaling(), other.managedInstanceScaling()) && Objects.equals(this.routingConfig(), other.routingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantSummary").add("VariantName", (Object)this.variantName()).add("DeployedImages", this.hasDeployedImages() ? this.deployedImages() : null).add("CurrentWeight", (Object)this.currentWeight()).add("DesiredWeight", (Object)this.desiredWeight()).add("CurrentInstanceCount", (Object)this.currentInstanceCount()).add("DesiredInstanceCount", (Object)this.desiredInstanceCount()).add("VariantStatus", this.hasVariantStatus() ? this.variantStatus() : null).add("CurrentServerlessConfig", (Object)this.currentServerlessConfig()).add("DesiredServerlessConfig", (Object)this.desiredServerlessConfig()).add("ManagedInstanceScaling", (Object)this.managedInstanceScaling()).add("RoutingConfig", (Object)this.routingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "DeployedImages": {
                return Optional.ofNullable(clazz.cast(this.deployedImages()));
            }
            case "CurrentWeight": {
                return Optional.ofNullable(clazz.cast(this.currentWeight()));
            }
            case "DesiredWeight": {
                return Optional.ofNullable(clazz.cast(this.desiredWeight()));
            }
            case "CurrentInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.currentInstanceCount()));
            }
            case "DesiredInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.desiredInstanceCount()));
            }
            case "VariantStatus": {
                return Optional.ofNullable(clazz.cast(this.variantStatus()));
            }
            case "CurrentServerlessConfig": {
                return Optional.ofNullable(clazz.cast(this.currentServerlessConfig()));
            }
            case "DesiredServerlessConfig": {
                return Optional.ofNullable(clazz.cast(this.desiredServerlessConfig()));
            }
            case "ManagedInstanceScaling": {
                return Optional.ofNullable(clazz.cast(this.managedInstanceScaling()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VariantName", VARIANT_NAME_FIELD);
        map.put("DeployedImages", DEPLOYED_IMAGES_FIELD);
        map.put("CurrentWeight", CURRENT_WEIGHT_FIELD);
        map.put("DesiredWeight", DESIRED_WEIGHT_FIELD);
        map.put("CurrentInstanceCount", CURRENT_INSTANCE_COUNT_FIELD);
        map.put("DesiredInstanceCount", DESIRED_INSTANCE_COUNT_FIELD);
        map.put("VariantStatus", VARIANT_STATUS_FIELD);
        map.put("CurrentServerlessConfig", CURRENT_SERVERLESS_CONFIG_FIELD);
        map.put("DesiredServerlessConfig", DESIRED_SERVERLESS_CONFIG_FIELD);
        map.put("ManagedInstanceScaling", MANAGED_INSTANCE_SCALING_FIELD);
        map.put("RoutingConfig", ROUTING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantSummary, T> g) {
        return obj -> g.apply((ProductionVariantSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private List<DeployedImage> deployedImages = DefaultSdkAutoConstructList.getInstance();
        private Float currentWeight;
        private Float desiredWeight;
        private Integer currentInstanceCount;
        private Integer desiredInstanceCount;
        private List<ProductionVariantStatus> variantStatus = DefaultSdkAutoConstructList.getInstance();
        private ProductionVariantServerlessConfig currentServerlessConfig;
        private ProductionVariantServerlessConfig desiredServerlessConfig;
        private ProductionVariantManagedInstanceScaling managedInstanceScaling;
        private ProductionVariantRoutingConfig routingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantSummary model) {
            this.variantName(model.variantName);
            this.deployedImages(model.deployedImages);
            this.currentWeight(model.currentWeight);
            this.desiredWeight(model.desiredWeight);
            this.currentInstanceCount(model.currentInstanceCount);
            this.desiredInstanceCount(model.desiredInstanceCount);
            this.variantStatus(model.variantStatus);
            this.currentServerlessConfig(model.currentServerlessConfig);
            this.desiredServerlessConfig(model.desiredServerlessConfig);
            this.managedInstanceScaling(model.managedInstanceScaling);
            this.routingConfig(model.routingConfig);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final List<DeployedImage.Builder> getDeployedImages() {
            List<DeployedImage.Builder> result = DeployedImagesCopier.copyToBuilder(this.deployedImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployedImages(Collection<DeployedImage.BuilderImpl> deployedImages) {
            this.deployedImages = DeployedImagesCopier.copyFromBuilder(deployedImages);
        }

        @Override
        public final Builder deployedImages(Collection<DeployedImage> deployedImages) {
            this.deployedImages = DeployedImagesCopier.copy(deployedImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployedImages(DeployedImage ... deployedImages) {
            this.deployedImages(Arrays.asList(deployedImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployedImages(Consumer<DeployedImage.Builder> ... deployedImages) {
            this.deployedImages(Stream.of(deployedImages).map(c -> (DeployedImage)((DeployedImage.Builder)DeployedImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getCurrentWeight() {
            return this.currentWeight;
        }

        public final void setCurrentWeight(Float currentWeight) {
            this.currentWeight = currentWeight;
        }

        @Override
        public final Builder currentWeight(Float currentWeight) {
            this.currentWeight = currentWeight;
            return this;
        }

        public final Float getDesiredWeight() {
            return this.desiredWeight;
        }

        public final void setDesiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
        }

        @Override
        public final Builder desiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
            return this;
        }

        public final Integer getCurrentInstanceCount() {
            return this.currentInstanceCount;
        }

        public final void setCurrentInstanceCount(Integer currentInstanceCount) {
            this.currentInstanceCount = currentInstanceCount;
        }

        @Override
        public final Builder currentInstanceCount(Integer currentInstanceCount) {
            this.currentInstanceCount = currentInstanceCount;
            return this;
        }

        public final Integer getDesiredInstanceCount() {
            return this.desiredInstanceCount;
        }

        public final void setDesiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
        }

        @Override
        public final Builder desiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
            return this;
        }

        public final List<ProductionVariantStatus.Builder> getVariantStatus() {
            List<ProductionVariantStatus.Builder> result = ProductionVariantStatusListCopier.copyToBuilder(this.variantStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariantStatus(Collection<ProductionVariantStatus.BuilderImpl> variantStatus) {
            this.variantStatus = ProductionVariantStatusListCopier.copyFromBuilder(variantStatus);
        }

        @Override
        public final Builder variantStatus(Collection<ProductionVariantStatus> variantStatus) {
            this.variantStatus = ProductionVariantStatusListCopier.copy(variantStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStatus(ProductionVariantStatus ... variantStatus) {
            this.variantStatus(Arrays.asList(variantStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStatus(Consumer<ProductionVariantStatus.Builder> ... variantStatus) {
            this.variantStatus(Stream.of(variantStatus).map(c -> (ProductionVariantStatus)((ProductionVariantStatus.Builder)ProductionVariantStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProductionVariantServerlessConfig.Builder getCurrentServerlessConfig() {
            return this.currentServerlessConfig != null ? this.currentServerlessConfig.toBuilder() : null;
        }

        public final void setCurrentServerlessConfig(ProductionVariantServerlessConfig.BuilderImpl currentServerlessConfig) {
            this.currentServerlessConfig = currentServerlessConfig != null ? currentServerlessConfig.build() : null;
        }

        @Override
        public final Builder currentServerlessConfig(ProductionVariantServerlessConfig currentServerlessConfig) {
            this.currentServerlessConfig = currentServerlessConfig;
            return this;
        }

        public final ProductionVariantServerlessConfig.Builder getDesiredServerlessConfig() {
            return this.desiredServerlessConfig != null ? this.desiredServerlessConfig.toBuilder() : null;
        }

        public final void setDesiredServerlessConfig(ProductionVariantServerlessConfig.BuilderImpl desiredServerlessConfig) {
            this.desiredServerlessConfig = desiredServerlessConfig != null ? desiredServerlessConfig.build() : null;
        }

        @Override
        public final Builder desiredServerlessConfig(ProductionVariantServerlessConfig desiredServerlessConfig) {
            this.desiredServerlessConfig = desiredServerlessConfig;
            return this;
        }

        public final ProductionVariantManagedInstanceScaling.Builder getManagedInstanceScaling() {
            return this.managedInstanceScaling != null ? this.managedInstanceScaling.toBuilder() : null;
        }

        public final void setManagedInstanceScaling(ProductionVariantManagedInstanceScaling.BuilderImpl managedInstanceScaling) {
            this.managedInstanceScaling = managedInstanceScaling != null ? managedInstanceScaling.build() : null;
        }

        @Override
        public final Builder managedInstanceScaling(ProductionVariantManagedInstanceScaling managedInstanceScaling) {
            this.managedInstanceScaling = managedInstanceScaling;
            return this;
        }

        public final ProductionVariantRoutingConfig.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(ProductionVariantRoutingConfig.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(ProductionVariantRoutingConfig routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public ProductionVariantSummary build() {
            return new ProductionVariantSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantSummary> {
        public Builder variantName(String var1);

        public Builder deployedImages(Collection<DeployedImage> var1);

        public Builder deployedImages(DeployedImage ... var1);

        public Builder deployedImages(Consumer<DeployedImage.Builder> ... var1);

        public Builder currentWeight(Float var1);

        public Builder desiredWeight(Float var1);

        public Builder currentInstanceCount(Integer var1);

        public Builder desiredInstanceCount(Integer var1);

        public Builder variantStatus(Collection<ProductionVariantStatus> var1);

        public Builder variantStatus(ProductionVariantStatus ... var1);

        public Builder variantStatus(Consumer<ProductionVariantStatus.Builder> ... var1);

        public Builder currentServerlessConfig(ProductionVariantServerlessConfig var1);

        default public Builder currentServerlessConfig(Consumer<ProductionVariantServerlessConfig.Builder> currentServerlessConfig) {
            return this.currentServerlessConfig((ProductionVariantServerlessConfig)((ProductionVariantServerlessConfig.Builder)ProductionVariantServerlessConfig.builder().applyMutation(currentServerlessConfig)).build());
        }

        public Builder desiredServerlessConfig(ProductionVariantServerlessConfig var1);

        default public Builder desiredServerlessConfig(Consumer<ProductionVariantServerlessConfig.Builder> desiredServerlessConfig) {
            return this.desiredServerlessConfig((ProductionVariantServerlessConfig)((ProductionVariantServerlessConfig.Builder)ProductionVariantServerlessConfig.builder().applyMutation(desiredServerlessConfig)).build());
        }

        public Builder managedInstanceScaling(ProductionVariantManagedInstanceScaling var1);

        default public Builder managedInstanceScaling(Consumer<ProductionVariantManagedInstanceScaling.Builder> managedInstanceScaling) {
            return this.managedInstanceScaling((ProductionVariantManagedInstanceScaling)((ProductionVariantManagedInstanceScaling.Builder)ProductionVariantManagedInstanceScaling.builder().applyMutation(managedInstanceScaling)).build());
        }

        public Builder routingConfig(ProductionVariantRoutingConfig var1);

        default public Builder routingConfig(Consumer<ProductionVariantRoutingConfig.Builder> routingConfig) {
            return this.routingConfig((ProductionVariantRoutingConfig)((ProductionVariantRoutingConfig.Builder)ProductionVariantRoutingConfig.builder().applyMutation(routingConfig)).build());
        }
    }
}

