/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacitySummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacitySummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResourceName;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResourceNamesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrainingPlanResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeTrainingPlanResponse> {
    private static final SdkField<String> TRAINING_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanArn").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::trainingPlanArn)).setter(DescribeTrainingPlanResponse.setter(Builder::trainingPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanArn").build()}).build();
    private static final SdkField<String> TRAINING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanName").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::trainingPlanName)).setter(DescribeTrainingPlanResponse.setter(Builder::trainingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::statusAsString)).setter(DescribeTrainingPlanResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::statusMessage)).setter(DescribeTrainingPlanResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationHours").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::durationHours)).setter(DescribeTrainingPlanResponse.setter(Builder::durationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()}).build();
    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMinutes").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::durationMinutes)).setter(DescribeTrainingPlanResponse.setter(Builder::durationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::startTime)).setter(DescribeTrainingPlanResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::endTime)).setter(DescribeTrainingPlanResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontFee").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::upfrontFee)).setter(DescribeTrainingPlanResponse.setter(Builder::upfrontFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::currencyCode)).setter(DescribeTrainingPlanResponse.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::totalInstanceCount)).setter(DescribeTrainingPlanResponse.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::availableInstanceCount)).setter(DescribeTrainingPlanResponse.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build()}).build();
    private static final SdkField<Integer> IN_USE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InUseInstanceCount").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::inUseInstanceCount)).setter(DescribeTrainingPlanResponse.setter(Builder::inUseInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseInstanceCount").build()}).build();
    private static final SdkField<List<String>> TARGET_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetResources").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::targetResourcesAsStrings)).setter(DescribeTrainingPlanResponse.setter(Builder::targetResourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReservedCapacitySummary>> RESERVED_CAPACITY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedCapacitySummaries").getter(DescribeTrainingPlanResponse.getter(DescribeTrainingPlanResponse::reservedCapacitySummaries)).setter(DescribeTrainingPlanResponse.setter(Builder::reservedCapacitySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacitySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedCapacitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_ARN_FIELD, TRAINING_PLAN_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD, UPFRONT_FEE_FIELD, CURRENCY_CODE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, IN_USE_INSTANCE_COUNT_FIELD, TARGET_RESOURCES_FIELD, RESERVED_CAPACITY_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTrainingPlanResponse.memberNameToFieldInitializer();
    private final String trainingPlanArn;
    private final String trainingPlanName;
    private final String status;
    private final String statusMessage;
    private final Long durationHours;
    private final Long durationMinutes;
    private final Instant startTime;
    private final Instant endTime;
    private final String upfrontFee;
    private final String currencyCode;
    private final Integer totalInstanceCount;
    private final Integer availableInstanceCount;
    private final Integer inUseInstanceCount;
    private final List<String> targetResources;
    private final List<ReservedCapacitySummary> reservedCapacitySummaries;

    private DescribeTrainingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.trainingPlanArn = builder.trainingPlanArn;
        this.trainingPlanName = builder.trainingPlanName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.inUseInstanceCount = builder.inUseInstanceCount;
        this.targetResources = builder.targetResources;
        this.reservedCapacitySummaries = builder.reservedCapacitySummaries;
    }

    public final String trainingPlanArn() {
        return this.trainingPlanArn;
    }

    public final String trainingPlanName() {
        return this.trainingPlanName;
    }

    public final TrainingPlanStatus status() {
        return TrainingPlanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Long durationHours() {
        return this.durationHours;
    }

    public final Long durationMinutes() {
        return this.durationMinutes;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String upfrontFee() {
        return this.upfrontFee;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Integer inUseInstanceCount() {
        return this.inUseInstanceCount;
    }

    public final List<SageMakerResourceName> targetResources() {
        return SageMakerResourceNamesCopier.copyStringToEnum(this.targetResources);
    }

    public final boolean hasTargetResources() {
        return this.targetResources != null && !(this.targetResources instanceof SdkAutoConstructList);
    }

    public final List<String> targetResourcesAsStrings() {
        return this.targetResources;
    }

    public final boolean hasReservedCapacitySummaries() {
        return this.reservedCapacitySummaries != null && !(this.reservedCapacitySummaries instanceof SdkAutoConstructList);
    }

    public final List<ReservedCapacitySummary> reservedCapacitySummaries() {
        return this.reservedCapacitySummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResources() ? this.targetResourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedCapacitySummaries() ? this.reservedCapacitySummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingPlanResponse)) {
            return false;
        }
        DescribeTrainingPlanResponse other = (DescribeTrainingPlanResponse)((Object)obj);
        return Objects.equals(this.trainingPlanArn(), other.trainingPlanArn()) && Objects.equals(this.trainingPlanName(), other.trainingPlanName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.durationHours(), other.durationHours()) && Objects.equals(this.durationMinutes(), other.durationMinutes()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.upfrontFee(), other.upfrontFee()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.inUseInstanceCount(), other.inUseInstanceCount()) && this.hasTargetResources() == other.hasTargetResources() && Objects.equals(this.targetResourcesAsStrings(), other.targetResourcesAsStrings()) && this.hasReservedCapacitySummaries() == other.hasReservedCapacitySummaries() && Objects.equals(this.reservedCapacitySummaries(), other.reservedCapacitySummaries());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrainingPlanResponse").add("TrainingPlanArn", (Object)this.trainingPlanArn()).add("TrainingPlanName", (Object)this.trainingPlanName()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("DurationHours", (Object)this.durationHours()).add("DurationMinutes", (Object)this.durationMinutes()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("UpfrontFee", (Object)this.upfrontFee()).add("CurrencyCode", (Object)this.currencyCode()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("InUseInstanceCount", (Object)this.inUseInstanceCount()).add("TargetResources", this.hasTargetResources() ? this.targetResourcesAsStrings() : null).add("ReservedCapacitySummaries", this.hasReservedCapacitySummaries() ? this.reservedCapacitySummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingPlanArn": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanArn()));
            }
            case "TrainingPlanName": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "DurationHours": {
                return Optional.ofNullable(clazz.cast(this.durationHours()));
            }
            case "DurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.durationMinutes()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "UpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.upfrontFee()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "InUseInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.inUseInstanceCount()));
            }
            case "TargetResources": {
                return Optional.ofNullable(clazz.cast(this.targetResourcesAsStrings()));
            }
            case "ReservedCapacitySummaries": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacitySummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrainingPlanArn", TRAINING_PLAN_ARN_FIELD);
        map.put("TrainingPlanName", TRAINING_PLAN_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("InUseInstanceCount", IN_USE_INSTANCE_COUNT_FIELD);
        map.put("TargetResources", TARGET_RESOURCES_FIELD);
        map.put("ReservedCapacitySummaries", RESERVED_CAPACITY_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrainingPlanResponse, T> g) {
        return obj -> g.apply((DescribeTrainingPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String trainingPlanArn;
        private String trainingPlanName;
        private String status;
        private String statusMessage;
        private Long durationHours;
        private Long durationMinutes;
        private Instant startTime;
        private Instant endTime;
        private String upfrontFee;
        private String currencyCode;
        private Integer totalInstanceCount;
        private Integer availableInstanceCount;
        private Integer inUseInstanceCount;
        private List<String> targetResources = DefaultSdkAutoConstructList.getInstance();
        private List<ReservedCapacitySummary> reservedCapacitySummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrainingPlanResponse model) {
            super(model);
            this.trainingPlanArn(model.trainingPlanArn);
            this.trainingPlanName(model.trainingPlanName);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.durationHours(model.durationHours);
            this.durationMinutes(model.durationMinutes);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.upfrontFee(model.upfrontFee);
            this.currencyCode(model.currencyCode);
            this.totalInstanceCount(model.totalInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.inUseInstanceCount(model.inUseInstanceCount);
            this.targetResourcesWithStrings(model.targetResources);
            this.reservedCapacitySummaries(model.reservedCapacitySummaries);
        }

        public final String getTrainingPlanArn() {
            return this.trainingPlanArn;
        }

        public final void setTrainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
        }

        @Override
        public final Builder trainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
            return this;
        }

        public final String getTrainingPlanName() {
            return this.trainingPlanName;
        }

        public final void setTrainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
        }

        @Override
        public final Builder trainingPlanName(String trainingPlanName) {
            this.trainingPlanName = trainingPlanName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainingPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getDurationHours() {
            return this.durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return this.durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getUpfrontFee() {
            return this.upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getInUseInstanceCount() {
            return this.inUseInstanceCount;
        }

        public final void setInUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
        }

        @Override
        public final Builder inUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
            return this;
        }

        public final Collection<String> getTargetResources() {
            if (this.targetResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetResources;
        }

        public final void setTargetResources(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
        }

        @Override
        public final Builder targetResourcesWithStrings(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourcesWithStrings(String ... targetResources) {
            this.targetResourcesWithStrings(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public final Builder targetResources(Collection<SageMakerResourceName> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copyEnumToString(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResources(SageMakerResourceName ... targetResources) {
            this.targetResources(Arrays.asList(targetResources));
            return this;
        }

        public final List<ReservedCapacitySummary.Builder> getReservedCapacitySummaries() {
            List<ReservedCapacitySummary.Builder> result = ReservedCapacitySummariesCopier.copyToBuilder(this.reservedCapacitySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedCapacitySummaries(Collection<ReservedCapacitySummary.BuilderImpl> reservedCapacitySummaries) {
            this.reservedCapacitySummaries = ReservedCapacitySummariesCopier.copyFromBuilder(reservedCapacitySummaries);
        }

        @Override
        public final Builder reservedCapacitySummaries(Collection<ReservedCapacitySummary> reservedCapacitySummaries) {
            this.reservedCapacitySummaries = ReservedCapacitySummariesCopier.copy(reservedCapacitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCapacitySummaries(ReservedCapacitySummary ... reservedCapacitySummaries) {
            this.reservedCapacitySummaries(Arrays.asList(reservedCapacitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCapacitySummaries(Consumer<ReservedCapacitySummary.Builder> ... reservedCapacitySummaries) {
            this.reservedCapacitySummaries(Stream.of(reservedCapacitySummaries).map(c -> (ReservedCapacitySummary)((ReservedCapacitySummary.Builder)ReservedCapacitySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrainingPlanResponse build() {
            return new DescribeTrainingPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrainingPlanResponse> {
        public Builder trainingPlanArn(String var1);

        public Builder trainingPlanName(String var1);

        public Builder status(String var1);

        public Builder status(TrainingPlanStatus var1);

        public Builder statusMessage(String var1);

        public Builder durationHours(Long var1);

        public Builder durationMinutes(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder upfrontFee(String var1);

        public Builder currencyCode(String var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder inUseInstanceCount(Integer var1);

        public Builder targetResourcesWithStrings(Collection<String> var1);

        public Builder targetResourcesWithStrings(String ... var1);

        public Builder targetResources(Collection<SageMakerResourceName> var1);

        public Builder targetResources(SageMakerResourceName ... var1);

        public Builder reservedCapacitySummaries(Collection<ReservedCapacitySummary> var1);

        public Builder reservedCapacitySummaries(ReservedCapacitySummary ... var1);

        public Builder reservedCapacitySummaries(Consumer<ReservedCapacitySummary.Builder> ... var1);
    }
}

