/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Phase;
import software.amazon.awssdk.services.sagemaker.model.PhasesCopier;
import software.amazon.awssdk.services.sagemaker.model.Stairs;
import software.amazon.awssdk.services.sagemaker.model.TrafficType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficPattern
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficPattern> {
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficType").getter(TrafficPattern.getter(TrafficPattern::trafficTypeAsString)).setter(TrafficPattern.setter(Builder::trafficType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()}).build();
    private static final SdkField<List<Phase>> PHASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phases").getter(TrafficPattern.getter(TrafficPattern::phases)).setter(TrafficPattern.setter(Builder::phases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Stairs> STAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Stairs").getter(TrafficPattern.getter(TrafficPattern::stairs)).setter(TrafficPattern.setter(Builder::stairs)).constructor(Stairs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stairs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_TYPE_FIELD, PHASES_FIELD, STAIRS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrafficPattern.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trafficType;
    private final List<Phase> phases;
    private final Stairs stairs;

    private TrafficPattern(BuilderImpl builder) {
        this.trafficType = builder.trafficType;
        this.phases = builder.phases;
        this.stairs = builder.stairs;
    }

    public final TrafficType trafficType() {
        return TrafficType.fromValue(this.trafficType);
    }

    public final String trafficTypeAsString() {
        return this.trafficType;
    }

    public final boolean hasPhases() {
        return this.phases != null && !(this.phases instanceof SdkAutoConstructList);
    }

    public final List<Phase> phases() {
        return this.phases;
    }

    public final Stairs stairs() {
        return this.stairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhases() ? this.phases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stairs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPattern)) {
            return false;
        }
        TrafficPattern other = (TrafficPattern)obj;
        return Objects.equals(this.trafficTypeAsString(), other.trafficTypeAsString()) && this.hasPhases() == other.hasPhases() && Objects.equals(this.phases(), other.phases()) && Objects.equals(this.stairs(), other.stairs());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficPattern").add("TrafficType", (Object)this.trafficTypeAsString()).add("Phases", this.hasPhases() ? this.phases() : null).add("Stairs", (Object)this.stairs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficTypeAsString()));
            }
            case "Phases": {
                return Optional.ofNullable(clazz.cast(this.phases()));
            }
            case "Stairs": {
                return Optional.ofNullable(clazz.cast(this.stairs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrafficType", TRAFFIC_TYPE_FIELD);
        map.put("Phases", PHASES_FIELD);
        map.put("Stairs", STAIRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficPattern, T> g) {
        return obj -> g.apply((TrafficPattern)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficType;
        private List<Phase> phases = DefaultSdkAutoConstructList.getInstance();
        private Stairs stairs;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPattern model) {
            this.trafficType(model.trafficType);
            this.phases(model.phases);
            this.stairs(model.stairs);
        }

        public final String getTrafficType() {
            return this.trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final List<Phase.Builder> getPhases() {
            List<Phase.Builder> result = PhasesCopier.copyToBuilder(this.phases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhases(Collection<Phase.BuilderImpl> phases) {
            this.phases = PhasesCopier.copyFromBuilder(phases);
        }

        @Override
        public final Builder phases(Collection<Phase> phases) {
            this.phases = PhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Phase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<Phase.Builder> ... phases) {
            this.phases(Stream.of(phases).map(c -> (Phase)((Phase.Builder)Phase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Stairs.Builder getStairs() {
            return this.stairs != null ? this.stairs.toBuilder() : null;
        }

        public final void setStairs(Stairs.BuilderImpl stairs) {
            this.stairs = stairs != null ? stairs.build() : null;
        }

        @Override
        public final Builder stairs(Stairs stairs) {
            this.stairs = stairs;
            return this;
        }

        public TrafficPattern build() {
            return new TrafficPattern(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficPattern> {
        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);

        public Builder phases(Collection<Phase> var1);

        public Builder phases(Phase ... var1);

        public Builder phases(Consumer<Phase.Builder> ... var1);

        public Builder stairs(Stairs var1);

        default public Builder stairs(Consumer<Stairs.Builder> stairs) {
            return this.stairs((Stairs)((Stairs.Builder)Stairs.builder().applyMutation(stairs)).build());
        }
    }
}

