/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppAuthType;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppConfig;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppMaintenanceConfig;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePartnerAppRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreatePartnerAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::name)).setter(CreatePartnerAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::typeAsString)).setter(CreatePartnerAppRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::executionRoleArn)).setter(CreatePartnerAppRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<PartnerAppMaintenanceConfig> MAINTENANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceConfig").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::maintenanceConfig)).setter(CreatePartnerAppRequest.setter(Builder::maintenanceConfig)).constructor(PartnerAppMaintenanceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceConfig").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::tier)).setter(CreatePartnerAppRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<PartnerAppConfig> APPLICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationConfig").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::applicationConfig)).setter(CreatePartnerAppRequest.setter(Builder::applicationConfig)).constructor(PartnerAppConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfig").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::authTypeAsString)).setter(CreatePartnerAppRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIamSessionBasedIdentity").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::enableIamSessionBasedIdentity)).setter(CreatePartnerAppRequest.setter(Builder::enableIamSessionBasedIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIamSessionBasedIdentity").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::clientToken)).setter(CreatePartnerAppRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreatePartnerAppRequest.getter(CreatePartnerAppRequest::tags)).setter(CreatePartnerAppRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, EXECUTION_ROLE_ARN_FIELD, MAINTENANCE_CONFIG_FIELD, TIER_FIELD, APPLICATION_CONFIG_FIELD, AUTH_TYPE_FIELD, ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePartnerAppRequest.memberNameToFieldInitializer();
    private final String name;
    private final String type;
    private final String executionRoleArn;
    private final PartnerAppMaintenanceConfig maintenanceConfig;
    private final String tier;
    private final PartnerAppConfig applicationConfig;
    private final String authType;
    private final Boolean enableIamSessionBasedIdentity;
    private final String clientToken;
    private final List<Tag> tags;

    private CreatePartnerAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.executionRoleArn = builder.executionRoleArn;
        this.maintenanceConfig = builder.maintenanceConfig;
        this.tier = builder.tier;
        this.applicationConfig = builder.applicationConfig;
        this.authType = builder.authType;
        this.enableIamSessionBasedIdentity = builder.enableIamSessionBasedIdentity;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final PartnerAppType type() {
        return PartnerAppType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final PartnerAppMaintenanceConfig maintenanceConfig() {
        return this.maintenanceConfig;
    }

    public final String tier() {
        return this.tier;
    }

    public final PartnerAppConfig applicationConfig() {
        return this.applicationConfig;
    }

    public final PartnerAppAuthType authType() {
        return PartnerAppAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final Boolean enableIamSessionBasedIdentity() {
        return this.enableIamSessionBasedIdentity;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIamSessionBasedIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartnerAppRequest)) {
            return false;
        }
        CreatePartnerAppRequest other = (CreatePartnerAppRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.maintenanceConfig(), other.maintenanceConfig()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.applicationConfig(), other.applicationConfig()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.enableIamSessionBasedIdentity(), other.enableIamSessionBasedIdentity()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePartnerAppRequest").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("MaintenanceConfig", (Object)this.maintenanceConfig()).add("Tier", (Object)this.tier()).add("ApplicationConfig", (Object)this.applicationConfig()).add("AuthType", (Object)this.authTypeAsString()).add("EnableIamSessionBasedIdentity", (Object)this.enableIamSessionBasedIdentity()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "MaintenanceConfig": {
                return Optional.ofNullable(clazz.cast(this.maintenanceConfig()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "ApplicationConfig": {
                return Optional.ofNullable(clazz.cast(this.applicationConfig()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "EnableIamSessionBasedIdentity": {
                return Optional.ofNullable(clazz.cast(this.enableIamSessionBasedIdentity()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("MaintenanceConfig", MAINTENANCE_CONFIG_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("ApplicationConfig", APPLICATION_CONFIG_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("EnableIamSessionBasedIdentity", ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePartnerAppRequest, T> g) {
        return obj -> g.apply((CreatePartnerAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String executionRoleArn;
        private PartnerAppMaintenanceConfig maintenanceConfig;
        private String tier;
        private PartnerAppConfig applicationConfig;
        private String authType;
        private Boolean enableIamSessionBasedIdentity;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartnerAppRequest model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.executionRoleArn(model.executionRoleArn);
            this.maintenanceConfig(model.maintenanceConfig);
            this.tier(model.tier);
            this.applicationConfig(model.applicationConfig);
            this.authType(model.authType);
            this.enableIamSessionBasedIdentity(model.enableIamSessionBasedIdentity);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PartnerAppType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final PartnerAppMaintenanceConfig.Builder getMaintenanceConfig() {
            return this.maintenanceConfig != null ? this.maintenanceConfig.toBuilder() : null;
        }

        public final void setMaintenanceConfig(PartnerAppMaintenanceConfig.BuilderImpl maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig != null ? maintenanceConfig.build() : null;
        }

        @Override
        public final Builder maintenanceConfig(PartnerAppMaintenanceConfig maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final PartnerAppConfig.Builder getApplicationConfig() {
            return this.applicationConfig != null ? this.applicationConfig.toBuilder() : null;
        }

        public final void setApplicationConfig(PartnerAppConfig.BuilderImpl applicationConfig) {
            this.applicationConfig = applicationConfig != null ? applicationConfig.build() : null;
        }

        @Override
        public final Builder applicationConfig(PartnerAppConfig applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(PartnerAppAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Boolean getEnableIamSessionBasedIdentity() {
            return this.enableIamSessionBasedIdentity;
        }

        public final void setEnableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
        }

        @Override
        public final Builder enableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePartnerAppRequest build() {
            return new CreatePartnerAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePartnerAppRequest> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(PartnerAppType var1);

        public Builder executionRoleArn(String var1);

        public Builder maintenanceConfig(PartnerAppMaintenanceConfig var1);

        default public Builder maintenanceConfig(Consumer<PartnerAppMaintenanceConfig.Builder> maintenanceConfig) {
            return this.maintenanceConfig((PartnerAppMaintenanceConfig)((PartnerAppMaintenanceConfig.Builder)PartnerAppMaintenanceConfig.builder().applyMutation(maintenanceConfig)).build());
        }

        public Builder tier(String var1);

        public Builder applicationConfig(PartnerAppConfig var1);

        default public Builder applicationConfig(Consumer<PartnerAppConfig.Builder> applicationConfig) {
            return this.applicationConfig((PartnerAppConfig)((PartnerAppConfig.Builder)PartnerAppConfig.builder().applyMutation(applicationConfig)).build());
        }

        public Builder authType(String var1);

        public Builder authType(PartnerAppAuthType var1);

        public Builder enableIamSessionBasedIdentity(Boolean var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

