/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelCardExportJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelCardExportJobsResponse> {
    private static final SdkField<List<ModelCardExportJobSummary>> MODEL_CARD_EXPORT_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelCardExportJobSummaries").getter(ListModelCardExportJobsResponse.getter(ListModelCardExportJobsResponse::modelCardExportJobSummaries)).setter(ListModelCardExportJobsResponse.setter(Builder::modelCardExportJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelCardExportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelCardExportJobsResponse.getter(ListModelCardExportJobsResponse::nextToken)).setter(ListModelCardExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_EXPORT_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelCardExportJobsResponse.memberNameToFieldInitializer();
    private final List<ModelCardExportJobSummary> modelCardExportJobSummaries;
    private final String nextToken;

    private ListModelCardExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardExportJobSummaries = builder.modelCardExportJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelCardExportJobSummaries() {
        return this.modelCardExportJobSummaries != null && !(this.modelCardExportJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelCardExportJobSummary> modelCardExportJobSummaries() {
        return this.modelCardExportJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelCardExportJobSummaries() ? this.modelCardExportJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardExportJobsResponse)) {
            return false;
        }
        ListModelCardExportJobsResponse other = (ListModelCardExportJobsResponse)((Object)obj);
        return this.hasModelCardExportJobSummaries() == other.hasModelCardExportJobSummaries() && Objects.equals(this.modelCardExportJobSummaries(), other.modelCardExportJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelCardExportJobsResponse").add("ModelCardExportJobSummaries", this.hasModelCardExportJobSummaries() ? this.modelCardExportJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardExportJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelCardExportJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelCardExportJobSummaries", MODEL_CARD_EXPORT_JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardExportJobsResponse, T> g) {
        return obj -> g.apply((ListModelCardExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelCardExportJobSummary> modelCardExportJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardExportJobsResponse model) {
            super(model);
            this.modelCardExportJobSummaries(model.modelCardExportJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ModelCardExportJobSummary.Builder> getModelCardExportJobSummaries() {
            List<ModelCardExportJobSummary.Builder> result = ModelCardExportJobSummaryListCopier.copyToBuilder(this.modelCardExportJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCardExportJobSummaries(Collection<ModelCardExportJobSummary.BuilderImpl> modelCardExportJobSummaries) {
            this.modelCardExportJobSummaries = ModelCardExportJobSummaryListCopier.copyFromBuilder(modelCardExportJobSummaries);
        }

        @Override
        public final Builder modelCardExportJobSummaries(Collection<ModelCardExportJobSummary> modelCardExportJobSummaries) {
            this.modelCardExportJobSummaries = ModelCardExportJobSummaryListCopier.copy(modelCardExportJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardExportJobSummaries(ModelCardExportJobSummary ... modelCardExportJobSummaries) {
            this.modelCardExportJobSummaries(Arrays.asList(modelCardExportJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCardExportJobSummaries(Consumer<ModelCardExportJobSummary.Builder> ... modelCardExportJobSummaries) {
            this.modelCardExportJobSummaries(Stream.of(modelCardExportJobSummaries).map(c -> (ModelCardExportJobSummary)((ModelCardExportJobSummary.Builder)ModelCardExportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelCardExportJobsResponse build() {
            return new ListModelCardExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelCardExportJobsResponse> {
        public Builder modelCardExportJobSummaries(Collection<ModelCardExportJobSummary> var1);

        public Builder modelCardExportJobSummaries(ModelCardExportJobSummary ... var1);

        public Builder modelCardExportJobSummaries(Consumer<ModelCardExportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

