/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CacheHitResult;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepMetadata;
import software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionResult;
import software.amazon.awssdk.services.sagemaker.model.StepStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecutionStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecutionStep> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepName").getter(PipelineExecutionStep.getter(PipelineExecutionStep::stepName)).setter(PipelineExecutionStep.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepName").build()}).build();
    private static final SdkField<String> STEP_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepDisplayName").getter(PipelineExecutionStep.getter(PipelineExecutionStep::stepDisplayName)).setter(PipelineExecutionStep.setter(Builder::stepDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepDisplayName").build()}).build();
    private static final SdkField<String> STEP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepDescription").getter(PipelineExecutionStep.getter(PipelineExecutionStep::stepDescription)).setter(PipelineExecutionStep.setter(Builder::stepDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepDescription").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(PipelineExecutionStep.getter(PipelineExecutionStep::startTime)).setter(PipelineExecutionStep.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(PipelineExecutionStep.getter(PipelineExecutionStep::endTime)).setter(PipelineExecutionStep.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepStatus").getter(PipelineExecutionStep.getter(PipelineExecutionStep::stepStatusAsString)).setter(PipelineExecutionStep.setter(Builder::stepStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStatus").build()}).build();
    private static final SdkField<CacheHitResult> CACHE_HIT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheHitResult").getter(PipelineExecutionStep.getter(PipelineExecutionStep::cacheHitResult)).setter(PipelineExecutionStep.setter(Builder::cacheHitResult)).constructor(CacheHitResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheHitResult").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(PipelineExecutionStep.getter(PipelineExecutionStep::failureReason)).setter(PipelineExecutionStep.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<PipelineExecutionStepMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(PipelineExecutionStep.getter(PipelineExecutionStep::metadata)).setter(PipelineExecutionStep.setter(Builder::metadata)).constructor(PipelineExecutionStepMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<Integer> ATTEMPT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AttemptCount").getter(PipelineExecutionStep.getter(PipelineExecutionStep::attemptCount)).setter(PipelineExecutionStep.setter(Builder::attemptCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttemptCount").build()}).build();
    private static final SdkField<SelectiveExecutionResult> SELECTIVE_EXECUTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectiveExecutionResult").getter(PipelineExecutionStep.getter(PipelineExecutionStep::selectiveExecutionResult)).setter(PipelineExecutionStep.setter(Builder::selectiveExecutionResult)).constructor(SelectiveExecutionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectiveExecutionResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD, STEP_DISPLAY_NAME_FIELD, STEP_DESCRIPTION_FIELD, START_TIME_FIELD, END_TIME_FIELD, STEP_STATUS_FIELD, CACHE_HIT_RESULT_FIELD, FAILURE_REASON_FIELD, METADATA_FIELD, ATTEMPT_COUNT_FIELD, SELECTIVE_EXECUTION_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineExecutionStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stepName;
    private final String stepDisplayName;
    private final String stepDescription;
    private final Instant startTime;
    private final Instant endTime;
    private final String stepStatus;
    private final CacheHitResult cacheHitResult;
    private final String failureReason;
    private final PipelineExecutionStepMetadata metadata;
    private final Integer attemptCount;
    private final SelectiveExecutionResult selectiveExecutionResult;

    private PipelineExecutionStep(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.stepDisplayName = builder.stepDisplayName;
        this.stepDescription = builder.stepDescription;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.stepStatus = builder.stepStatus;
        this.cacheHitResult = builder.cacheHitResult;
        this.failureReason = builder.failureReason;
        this.metadata = builder.metadata;
        this.attemptCount = builder.attemptCount;
        this.selectiveExecutionResult = builder.selectiveExecutionResult;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final String stepDisplayName() {
        return this.stepDisplayName;
    }

    public final String stepDescription() {
        return this.stepDescription;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final StepStatus stepStatus() {
        return StepStatus.fromValue(this.stepStatus);
    }

    public final String stepStatusAsString() {
        return this.stepStatus;
    }

    public final CacheHitResult cacheHitResult() {
        return this.cacheHitResult;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final PipelineExecutionStepMetadata metadata() {
        return this.metadata;
    }

    public final Integer attemptCount() {
        return this.attemptCount;
    }

    public final SelectiveExecutionResult selectiveExecutionResult() {
        return this.selectiveExecutionResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheHitResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.attemptCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectiveExecutionResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionStep)) {
            return false;
        }
        PipelineExecutionStep other = (PipelineExecutionStep)obj;
        return Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.stepDisplayName(), other.stepDisplayName()) && Objects.equals(this.stepDescription(), other.stepDescription()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.stepStatusAsString(), other.stepStatusAsString()) && Objects.equals(this.cacheHitResult(), other.cacheHitResult()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.attemptCount(), other.attemptCount()) && Objects.equals(this.selectiveExecutionResult(), other.selectiveExecutionResult());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineExecutionStep").add("StepName", (Object)this.stepName()).add("StepDisplayName", (Object)this.stepDisplayName()).add("StepDescription", (Object)this.stepDescription()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StepStatus", (Object)this.stepStatusAsString()).add("CacheHitResult", (Object)this.cacheHitResult()).add("FailureReason", (Object)this.failureReason()).add("Metadata", (Object)this.metadata()).add("AttemptCount", (Object)this.attemptCount()).add("SelectiveExecutionResult", (Object)this.selectiveExecutionResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "StepDisplayName": {
                return Optional.ofNullable(clazz.cast(this.stepDisplayName()));
            }
            case "StepDescription": {
                return Optional.ofNullable(clazz.cast(this.stepDescription()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "StepStatus": {
                return Optional.ofNullable(clazz.cast(this.stepStatusAsString()));
            }
            case "CacheHitResult": {
                return Optional.ofNullable(clazz.cast(this.cacheHitResult()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "AttemptCount": {
                return Optional.ofNullable(clazz.cast(this.attemptCount()));
            }
            case "SelectiveExecutionResult": {
                return Optional.ofNullable(clazz.cast(this.selectiveExecutionResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StepName", STEP_NAME_FIELD);
        map.put("StepDisplayName", STEP_DISPLAY_NAME_FIELD);
        map.put("StepDescription", STEP_DESCRIPTION_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("StepStatus", STEP_STATUS_FIELD);
        map.put("CacheHitResult", CACHE_HIT_RESULT_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("AttemptCount", ATTEMPT_COUNT_FIELD);
        map.put("SelectiveExecutionResult", SELECTIVE_EXECUTION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionStep, T> g) {
        return obj -> g.apply((PipelineExecutionStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepName;
        private String stepDisplayName;
        private String stepDescription;
        private Instant startTime;
        private Instant endTime;
        private String stepStatus;
        private CacheHitResult cacheHitResult;
        private String failureReason;
        private PipelineExecutionStepMetadata metadata;
        private Integer attemptCount;
        private SelectiveExecutionResult selectiveExecutionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionStep model) {
            this.stepName(model.stepName);
            this.stepDisplayName(model.stepDisplayName);
            this.stepDescription(model.stepDescription);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.stepStatus(model.stepStatus);
            this.cacheHitResult(model.cacheHitResult);
            this.failureReason(model.failureReason);
            this.metadata(model.metadata);
            this.attemptCount(model.attemptCount);
            this.selectiveExecutionResult(model.selectiveExecutionResult);
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getStepDisplayName() {
            return this.stepDisplayName;
        }

        public final void setStepDisplayName(String stepDisplayName) {
            this.stepDisplayName = stepDisplayName;
        }

        @Override
        public final Builder stepDisplayName(String stepDisplayName) {
            this.stepDisplayName = stepDisplayName;
            return this;
        }

        public final String getStepDescription() {
            return this.stepDescription;
        }

        public final void setStepDescription(String stepDescription) {
            this.stepDescription = stepDescription;
        }

        @Override
        public final Builder stepDescription(String stepDescription) {
            this.stepDescription = stepDescription;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStepStatus() {
            return this.stepStatus;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(StepStatus stepStatus) {
            this.stepStatus(stepStatus == null ? null : stepStatus.toString());
            return this;
        }

        public final CacheHitResult.Builder getCacheHitResult() {
            return this.cacheHitResult != null ? this.cacheHitResult.toBuilder() : null;
        }

        public final void setCacheHitResult(CacheHitResult.BuilderImpl cacheHitResult) {
            this.cacheHitResult = cacheHitResult != null ? cacheHitResult.build() : null;
        }

        @Override
        public final Builder cacheHitResult(CacheHitResult cacheHitResult) {
            this.cacheHitResult = cacheHitResult;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final PipelineExecutionStepMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(PipelineExecutionStepMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(PipelineExecutionStepMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Integer getAttemptCount() {
            return this.attemptCount;
        }

        public final void setAttemptCount(Integer attemptCount) {
            this.attemptCount = attemptCount;
        }

        @Override
        public final Builder attemptCount(Integer attemptCount) {
            this.attemptCount = attemptCount;
            return this;
        }

        public final SelectiveExecutionResult.Builder getSelectiveExecutionResult() {
            return this.selectiveExecutionResult != null ? this.selectiveExecutionResult.toBuilder() : null;
        }

        public final void setSelectiveExecutionResult(SelectiveExecutionResult.BuilderImpl selectiveExecutionResult) {
            this.selectiveExecutionResult = selectiveExecutionResult != null ? selectiveExecutionResult.build() : null;
        }

        @Override
        public final Builder selectiveExecutionResult(SelectiveExecutionResult selectiveExecutionResult) {
            this.selectiveExecutionResult = selectiveExecutionResult;
            return this;
        }

        public PipelineExecutionStep build() {
            return new PipelineExecutionStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecutionStep> {
        public Builder stepName(String var1);

        public Builder stepDisplayName(String var1);

        public Builder stepDescription(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder stepStatus(String var1);

        public Builder stepStatus(StepStatus var1);

        public Builder cacheHitResult(CacheHitResult var1);

        default public Builder cacheHitResult(Consumer<CacheHitResult.Builder> cacheHitResult) {
            return this.cacheHitResult((CacheHitResult)((CacheHitResult.Builder)CacheHitResult.builder().applyMutation(cacheHitResult)).build());
        }

        public Builder failureReason(String var1);

        public Builder metadata(PipelineExecutionStepMetadata var1);

        default public Builder metadata(Consumer<PipelineExecutionStepMetadata.Builder> metadata) {
            return this.metadata((PipelineExecutionStepMetadata)((PipelineExecutionStepMetadata.Builder)PipelineExecutionStepMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder attemptCount(Integer var1);

        public Builder selectiveExecutionResult(SelectiveExecutionResult var1);

        default public Builder selectiveExecutionResult(Consumer<SelectiveExecutionResult.Builder> selectiveExecutionResult) {
            return this.selectiveExecutionResult((SelectiveExecutionResult)((SelectiveExecutionResult.Builder)SelectiveExecutionResult.builder().applyMutation(selectiveExecutionResult)).build());
        }
    }
}

