/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureParameter;
import software.amazon.awssdk.services.sagemaker.model.FeatureParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.FeatureType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFeatureMetadataResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeFeatureMetadataResponse> {
    private static final SdkField<String> FEATURE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupArn").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::featureGroupArn)).setter(DescribeFeatureMetadataResponse.setter(Builder::featureGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupArn").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::featureGroupName)).setter(DescribeFeatureMetadataResponse.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::featureName)).setter(DescribeFeatureMetadataResponse.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()}).build();
    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureType").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::featureTypeAsString)).setter(DescribeFeatureMetadataResponse.setter(Builder::featureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::creationTime)).setter(DescribeFeatureMetadataResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::lastModifiedTime)).setter(DescribeFeatureMetadataResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::description)).setter(DescribeFeatureMetadataResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<FeatureParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(DescribeFeatureMetadataResponse.getter(DescribeFeatureMetadataResponse::parameters)).setter(DescribeFeatureMetadataResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_ARN_FIELD, FEATURE_GROUP_NAME_FIELD, FEATURE_NAME_FIELD, FEATURE_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFeatureMetadataResponse.memberNameToFieldInitializer();
    private final String featureGroupArn;
    private final String featureGroupName;
    private final String featureName;
    private final String featureType;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String description;
    private final List<FeatureParameter> parameters;

    private DescribeFeatureMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.featureGroupArn = builder.featureGroupArn;
        this.featureGroupName = builder.featureGroupName;
        this.featureName = builder.featureName;
        this.featureType = builder.featureType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    public final String featureGroupArn() {
        return this.featureGroupArn;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final FeatureType featureType() {
        return FeatureType.fromValue(this.featureType);
    }

    public final String featureTypeAsString() {
        return this.featureType;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<FeatureParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeatureMetadataResponse)) {
            return false;
        }
        DescribeFeatureMetadataResponse other = (DescribeFeatureMetadataResponse)((Object)obj);
        return Objects.equals(this.featureGroupArn(), other.featureGroupArn()) && Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.featureTypeAsString(), other.featureTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.description(), other.description()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFeatureMetadataResponse").add("FeatureGroupArn", (Object)this.featureGroupArn()).add("FeatureGroupName", (Object)this.featureGroupName()).add("FeatureName", (Object)this.featureName()).add("FeatureType", (Object)this.featureTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Description", (Object)this.description()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupArn": {
                return Optional.ofNullable(clazz.cast(this.featureGroupArn()));
            }
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "FeatureType": {
                return Optional.ofNullable(clazz.cast(this.featureTypeAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeatureGroupArn", FEATURE_GROUP_ARN_FIELD);
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("FeatureName", FEATURE_NAME_FIELD);
        map.put("FeatureType", FEATURE_TYPE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeatureMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFeatureMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String featureGroupArn;
        private String featureGroupName;
        private String featureName;
        private String featureType;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String description;
        private List<FeatureParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeatureMetadataResponse model) {
            super(model);
            this.featureGroupArn(model.featureGroupArn);
            this.featureGroupName(model.featureGroupName);
            this.featureName(model.featureName);
            this.featureType(model.featureType);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.description(model.description);
            this.parameters(model.parameters);
        }

        public final String getFeatureGroupArn() {
            return this.featureGroupArn;
        }

        public final void setFeatureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
        }

        @Override
        public final Builder featureGroupArn(String featureGroupArn) {
            this.featureGroupArn = featureGroupArn;
            return this;
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getFeatureType() {
            return this.featureType;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(FeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FeatureParameter.Builder> getParameters() {
            List<FeatureParameter.Builder> result = FeatureParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<FeatureParameter.BuilderImpl> parameters) {
            this.parameters = FeatureParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<FeatureParameter> parameters) {
            this.parameters = FeatureParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(FeatureParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<FeatureParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (FeatureParameter)((FeatureParameter.Builder)FeatureParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeFeatureMetadataResponse build() {
            return new DescribeFeatureMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFeatureMetadataResponse> {
        public Builder featureGroupArn(String var1);

        public Builder featureGroupName(String var1);

        public Builder featureName(String var1);

        public Builder featureType(String var1);

        public Builder featureType(FeatureType var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder description(String var1);

        public Builder parameters(Collection<FeatureParameter> var1);

        public Builder parameters(FeatureParameter ... var1);

        public Builder parameters(Consumer<FeatureParameter.Builder> ... var1);
    }
}

