/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PartnerAppType {
    LAKERA_GUARD("lakera-guard"),
    COMET("comet"),
    DEEPCHECKS_LLM_EVALUATION("deepchecks-llm-evaluation"),
    FIDDLER("fiddler"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PartnerAppType> VALUE_MAP;
    private final String value;

    private PartnerAppType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PartnerAppType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PartnerAppType> knownValues() {
        EnumSet<PartnerAppType> knownValues = EnumSet.allOf(PartnerAppType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PartnerAppType.class, PartnerAppType::toString);
    }
}

