/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ExecutionStatus;
import software.amazon.awssdk.services.sagemaker.model.MonitoringType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringExecutionSummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleName").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::monitoringScheduleName)).setter(MonitoringExecutionSummary.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::scheduledTime)).setter(MonitoringExecutionSummary.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::creationTime)).setter(MonitoringExecutionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::lastModifiedTime)).setter(MonitoringExecutionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> MONITORING_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringExecutionStatus").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::monitoringExecutionStatusAsString)).setter(MonitoringExecutionSummary.setter(Builder::monitoringExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringExecutionStatus").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingJobArn").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::processingJobArn)).setter(MonitoringExecutionSummary.setter(Builder::processingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::endpointName)).setter(MonitoringExecutionSummary.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::failureReason)).setter(MonitoringExecutionSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> MONITORING_JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringJobDefinitionName").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::monitoringJobDefinitionName)).setter(MonitoringExecutionSummary.setter(Builder::monitoringJobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinitionName").build()}).build();
    private static final SdkField<String> MONITORING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringType").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::monitoringTypeAsString)).setter(MonitoringExecutionSummary.setter(Builder::monitoringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_NAME_FIELD, SCHEDULED_TIME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_EXECUTION_STATUS_FIELD, PROCESSING_JOB_ARN_FIELD, ENDPOINT_NAME_FIELD, FAILURE_REASON_FIELD, MONITORING_JOB_DEFINITION_NAME_FIELD, MONITORING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitoringExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String monitoringScheduleName;
    private final Instant scheduledTime;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String monitoringExecutionStatus;
    private final String processingJobArn;
    private final String endpointName;
    private final String failureReason;
    private final String monitoringJobDefinitionName;
    private final String monitoringType;

    private MonitoringExecutionSummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.scheduledTime = builder.scheduledTime;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringExecutionStatus = builder.monitoringExecutionStatus;
        this.processingJobArn = builder.processingJobArn;
        this.endpointName = builder.endpointName;
        this.failureReason = builder.failureReason;
        this.monitoringJobDefinitionName = builder.monitoringJobDefinitionName;
        this.monitoringType = builder.monitoringType;
    }

    public final String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public final Instant scheduledTime() {
        return this.scheduledTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final ExecutionStatus monitoringExecutionStatus() {
        return ExecutionStatus.fromValue(this.monitoringExecutionStatus);
    }

    public final String monitoringExecutionStatusAsString() {
        return this.monitoringExecutionStatus;
    }

    public final String processingJobArn() {
        return this.processingJobArn;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String monitoringJobDefinitionName() {
        return this.monitoringJobDefinitionName;
    }

    public final MonitoringType monitoringType() {
        return MonitoringType.fromValue(this.monitoringType);
    }

    public final String monitoringTypeAsString() {
        return this.monitoringType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringJobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringExecutionSummary)) {
            return false;
        }
        MonitoringExecutionSummary other = (MonitoringExecutionSummary)obj;
        return Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.scheduledTime(), other.scheduledTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.monitoringExecutionStatusAsString(), other.monitoringExecutionStatusAsString()) && Objects.equals(this.processingJobArn(), other.processingJobArn()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.monitoringJobDefinitionName(), other.monitoringJobDefinitionName()) && Objects.equals(this.monitoringTypeAsString(), other.monitoringTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringExecutionSummary").add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("ScheduledTime", (Object)this.scheduledTime()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MonitoringExecutionStatus", (Object)this.monitoringExecutionStatusAsString()).add("ProcessingJobArn", (Object)this.processingJobArn()).add("EndpointName", (Object)this.endpointName()).add("FailureReason", (Object)this.failureReason()).add("MonitoringJobDefinitionName", (Object)this.monitoringJobDefinitionName()).add("MonitoringType", (Object)this.monitoringTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "MonitoringExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.monitoringExecutionStatusAsString()));
            }
            case "ProcessingJobArn": {
                return Optional.ofNullable(clazz.cast(this.processingJobArn()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "MonitoringJobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.monitoringJobDefinitionName()));
            }
            case "MonitoringType": {
                return Optional.ofNullable(clazz.cast(this.monitoringTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
        map.put("ScheduledTime", SCHEDULED_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("MonitoringExecutionStatus", MONITORING_EXECUTION_STATUS_FIELD);
        map.put("ProcessingJobArn", PROCESSING_JOB_ARN_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("MonitoringJobDefinitionName", MONITORING_JOB_DEFINITION_NAME_FIELD);
        map.put("MonitoringType", MONITORING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringExecutionSummary, T> g) {
        return obj -> g.apply((MonitoringExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoringScheduleName;
        private Instant scheduledTime;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String monitoringExecutionStatus;
        private String processingJobArn;
        private String endpointName;
        private String failureReason;
        private String monitoringJobDefinitionName;
        private String monitoringType;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringExecutionSummary model) {
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.scheduledTime(model.scheduledTime);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.monitoringExecutionStatus(model.monitoringExecutionStatus);
            this.processingJobArn(model.processingJobArn);
            this.endpointName(model.endpointName);
            this.failureReason(model.failureReason);
            this.monitoringJobDefinitionName(model.monitoringJobDefinitionName);
            this.monitoringType(model.monitoringType);
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getMonitoringExecutionStatus() {
            return this.monitoringExecutionStatus;
        }

        public final void setMonitoringExecutionStatus(String monitoringExecutionStatus) {
            this.monitoringExecutionStatus = monitoringExecutionStatus;
        }

        @Override
        public final Builder monitoringExecutionStatus(String monitoringExecutionStatus) {
            this.monitoringExecutionStatus = monitoringExecutionStatus;
            return this;
        }

        @Override
        public final Builder monitoringExecutionStatus(ExecutionStatus monitoringExecutionStatus) {
            this.monitoringExecutionStatus(monitoringExecutionStatus == null ? null : monitoringExecutionStatus.toString());
            return this;
        }

        public final String getProcessingJobArn() {
            return this.processingJobArn;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getMonitoringJobDefinitionName() {
            return this.monitoringJobDefinitionName;
        }

        public final void setMonitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
        }

        @Override
        public final Builder monitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
            return this;
        }

        public final String getMonitoringType() {
            return this.monitoringType;
        }

        public final void setMonitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
        }

        @Override
        public final Builder monitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
            return this;
        }

        @Override
        public final Builder monitoringType(MonitoringType monitoringType) {
            this.monitoringType(monitoringType == null ? null : monitoringType.toString());
            return this;
        }

        public MonitoringExecutionSummary build() {
            return new MonitoringExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringExecutionSummary> {
        public Builder monitoringScheduleName(String var1);

        public Builder scheduledTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder monitoringExecutionStatus(String var1);

        public Builder monitoringExecutionStatus(ExecutionStatus var1);

        public Builder processingJobArn(String var1);

        public Builder endpointName(String var1);

        public Builder failureReason(String var1);

        public Builder monitoringJobDefinitionName(String var1);

        public Builder monitoringType(String var1);

        public Builder monitoringType(MonitoringType var1);
    }
}

