/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionTaskKeywordsCopier;
import software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanLoopConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanLoopConfig> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamArn").getter(HumanLoopConfig.getter(HumanLoopConfig::workteamArn)).setter(HumanLoopConfig.setter(Builder::workteamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()}).build();
    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanTaskUiArn").getter(HumanLoopConfig.getter(HumanLoopConfig::humanTaskUiArn)).setter(HumanLoopConfig.setter(Builder::humanTaskUiArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()}).build();
    private static final SdkField<String> TASK_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskTitle").getter(HumanLoopConfig.getter(HumanLoopConfig::taskTitle)).setter(HumanLoopConfig.setter(Builder::taskTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTitle").build()}).build();
    private static final SdkField<String> TASK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskDescription").getter(HumanLoopConfig.getter(HumanLoopConfig::taskDescription)).setter(HumanLoopConfig.setter(Builder::taskDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDescription").build()}).build();
    private static final SdkField<Integer> TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskCount").getter(HumanLoopConfig.getter(HumanLoopConfig::taskCount)).setter(HumanLoopConfig.setter(Builder::taskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskCount").build()}).build();
    private static final SdkField<Integer> TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskAvailabilityLifetimeInSeconds").getter(HumanLoopConfig.getter(HumanLoopConfig::taskAvailabilityLifetimeInSeconds)).setter(HumanLoopConfig.setter(Builder::taskAvailabilityLifetimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAvailabilityLifetimeInSeconds").build()}).build();
    private static final SdkField<Integer> TASK_TIME_LIMIT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskTimeLimitInSeconds").getter(HumanLoopConfig.getter(HumanLoopConfig::taskTimeLimitInSeconds)).setter(HumanLoopConfig.setter(Builder::taskTimeLimitInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTimeLimitInSeconds").build()}).build();
    private static final SdkField<List<String>> TASK_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskKeywords").getter(HumanLoopConfig.getter(HumanLoopConfig::taskKeywords)).setter(HumanLoopConfig.setter(Builder::taskKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PublicWorkforceTaskPrice> PUBLIC_WORKFORCE_TASK_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicWorkforceTaskPrice").getter(HumanLoopConfig.getter(HumanLoopConfig::publicWorkforceTaskPrice)).setter(HumanLoopConfig.setter(Builder::publicWorkforceTaskPrice)).constructor(PublicWorkforceTaskPrice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicWorkforceTaskPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD, HUMAN_TASK_UI_ARN_FIELD, TASK_TITLE_FIELD, TASK_DESCRIPTION_FIELD, TASK_COUNT_FIELD, TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD, TASK_TIME_LIMIT_IN_SECONDS_FIELD, TASK_KEYWORDS_FIELD, PUBLIC_WORKFORCE_TASK_PRICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HumanLoopConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workteamArn;
    private final String humanTaskUiArn;
    private final String taskTitle;
    private final String taskDescription;
    private final Integer taskCount;
    private final Integer taskAvailabilityLifetimeInSeconds;
    private final Integer taskTimeLimitInSeconds;
    private final List<String> taskKeywords;
    private final PublicWorkforceTaskPrice publicWorkforceTaskPrice;

    private HumanLoopConfig(BuilderImpl builder) {
        this.workteamArn = builder.workteamArn;
        this.humanTaskUiArn = builder.humanTaskUiArn;
        this.taskTitle = builder.taskTitle;
        this.taskDescription = builder.taskDescription;
        this.taskCount = builder.taskCount;
        this.taskAvailabilityLifetimeInSeconds = builder.taskAvailabilityLifetimeInSeconds;
        this.taskTimeLimitInSeconds = builder.taskTimeLimitInSeconds;
        this.taskKeywords = builder.taskKeywords;
        this.publicWorkforceTaskPrice = builder.publicWorkforceTaskPrice;
    }

    public final String workteamArn() {
        return this.workteamArn;
    }

    public final String humanTaskUiArn() {
        return this.humanTaskUiArn;
    }

    public final String taskTitle() {
        return this.taskTitle;
    }

    public final String taskDescription() {
        return this.taskDescription;
    }

    public final Integer taskCount() {
        return this.taskCount;
    }

    public final Integer taskAvailabilityLifetimeInSeconds() {
        return this.taskAvailabilityLifetimeInSeconds;
    }

    public final Integer taskTimeLimitInSeconds() {
        return this.taskTimeLimitInSeconds;
    }

    public final boolean hasTaskKeywords() {
        return this.taskKeywords != null && !(this.taskKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> taskKeywords() {
        return this.taskKeywords;
    }

    public final PublicWorkforceTaskPrice publicWorkforceTaskPrice() {
        return this.publicWorkforceTaskPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskUiArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskAvailabilityLifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTimeLimitInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskKeywords() ? this.taskKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicWorkforceTaskPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopConfig)) {
            return false;
        }
        HumanLoopConfig other = (HumanLoopConfig)obj;
        return Objects.equals(this.workteamArn(), other.workteamArn()) && Objects.equals(this.humanTaskUiArn(), other.humanTaskUiArn()) && Objects.equals(this.taskTitle(), other.taskTitle()) && Objects.equals(this.taskDescription(), other.taskDescription()) && Objects.equals(this.taskCount(), other.taskCount()) && Objects.equals(this.taskAvailabilityLifetimeInSeconds(), other.taskAvailabilityLifetimeInSeconds()) && Objects.equals(this.taskTimeLimitInSeconds(), other.taskTimeLimitInSeconds()) && this.hasTaskKeywords() == other.hasTaskKeywords() && Objects.equals(this.taskKeywords(), other.taskKeywords()) && Objects.equals(this.publicWorkforceTaskPrice(), other.publicWorkforceTaskPrice());
    }

    public final String toString() {
        return ToString.builder((String)"HumanLoopConfig").add("WorkteamArn", (Object)this.workteamArn()).add("HumanTaskUiArn", (Object)this.humanTaskUiArn()).add("TaskTitle", (Object)this.taskTitle()).add("TaskDescription", (Object)this.taskDescription()).add("TaskCount", (Object)this.taskCount()).add("TaskAvailabilityLifetimeInSeconds", (Object)this.taskAvailabilityLifetimeInSeconds()).add("TaskTimeLimitInSeconds", (Object)this.taskTimeLimitInSeconds()).add("TaskKeywords", this.hasTaskKeywords() ? this.taskKeywords() : null).add("PublicWorkforceTaskPrice", (Object)this.publicWorkforceTaskPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkteamArn": {
                return Optional.ofNullable(clazz.cast(this.workteamArn()));
            }
            case "HumanTaskUiArn": {
                return Optional.ofNullable(clazz.cast(this.humanTaskUiArn()));
            }
            case "TaskTitle": {
                return Optional.ofNullable(clazz.cast(this.taskTitle()));
            }
            case "TaskDescription": {
                return Optional.ofNullable(clazz.cast(this.taskDescription()));
            }
            case "TaskCount": {
                return Optional.ofNullable(clazz.cast(this.taskCount()));
            }
            case "TaskAvailabilityLifetimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.taskAvailabilityLifetimeInSeconds()));
            }
            case "TaskTimeLimitInSeconds": {
                return Optional.ofNullable(clazz.cast(this.taskTimeLimitInSeconds()));
            }
            case "TaskKeywords": {
                return Optional.ofNullable(clazz.cast(this.taskKeywords()));
            }
            case "PublicWorkforceTaskPrice": {
                return Optional.ofNullable(clazz.cast(this.publicWorkforceTaskPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkteamArn", WORKTEAM_ARN_FIELD);
        map.put("HumanTaskUiArn", HUMAN_TASK_UI_ARN_FIELD);
        map.put("TaskTitle", TASK_TITLE_FIELD);
        map.put("TaskDescription", TASK_DESCRIPTION_FIELD);
        map.put("TaskCount", TASK_COUNT_FIELD);
        map.put("TaskAvailabilityLifetimeInSeconds", TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD);
        map.put("TaskTimeLimitInSeconds", TASK_TIME_LIMIT_IN_SECONDS_FIELD);
        map.put("TaskKeywords", TASK_KEYWORDS_FIELD);
        map.put("PublicWorkforceTaskPrice", PUBLIC_WORKFORCE_TASK_PRICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopConfig, T> g) {
        return obj -> g.apply((HumanLoopConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workteamArn;
        private String humanTaskUiArn;
        private String taskTitle;
        private String taskDescription;
        private Integer taskCount;
        private Integer taskAvailabilityLifetimeInSeconds;
        private Integer taskTimeLimitInSeconds;
        private List<String> taskKeywords = DefaultSdkAutoConstructList.getInstance();
        private PublicWorkforceTaskPrice publicWorkforceTaskPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopConfig model) {
            this.workteamArn(model.workteamArn);
            this.humanTaskUiArn(model.humanTaskUiArn);
            this.taskTitle(model.taskTitle);
            this.taskDescription(model.taskDescription);
            this.taskCount(model.taskCount);
            this.taskAvailabilityLifetimeInSeconds(model.taskAvailabilityLifetimeInSeconds);
            this.taskTimeLimitInSeconds(model.taskTimeLimitInSeconds);
            this.taskKeywords(model.taskKeywords);
            this.publicWorkforceTaskPrice(model.publicWorkforceTaskPrice);
        }

        public final String getWorkteamArn() {
            return this.workteamArn;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final String getHumanTaskUiArn() {
            return this.humanTaskUiArn;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final String getTaskTitle() {
            return this.taskTitle;
        }

        public final void setTaskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
        }

        @Override
        public final Builder taskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
            return this;
        }

        public final String getTaskDescription() {
            return this.taskDescription;
        }

        public final void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        @Override
        public final Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            return this;
        }

        public final Integer getTaskCount() {
            return this.taskCount;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final Integer getTaskAvailabilityLifetimeInSeconds() {
            return this.taskAvailabilityLifetimeInSeconds;
        }

        public final void setTaskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
        }

        @Override
        public final Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
            return this;
        }

        public final Integer getTaskTimeLimitInSeconds() {
            return this.taskTimeLimitInSeconds;
        }

        public final void setTaskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
        }

        @Override
        public final Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
            return this;
        }

        public final Collection<String> getTaskKeywords() {
            if (this.taskKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskKeywords;
        }

        public final void setTaskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = FlowDefinitionTaskKeywordsCopier.copy(taskKeywords);
        }

        @Override
        public final Builder taskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = FlowDefinitionTaskKeywordsCopier.copy(taskKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskKeywords(String ... taskKeywords) {
            this.taskKeywords(Arrays.asList(taskKeywords));
            return this;
        }

        public final PublicWorkforceTaskPrice.Builder getPublicWorkforceTaskPrice() {
            return this.publicWorkforceTaskPrice != null ? this.publicWorkforceTaskPrice.toBuilder() : null;
        }

        public final void setPublicWorkforceTaskPrice(PublicWorkforceTaskPrice.BuilderImpl publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.build() : null;
        }

        @Override
        public final Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice;
            return this;
        }

        public HumanLoopConfig build() {
            return new HumanLoopConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanLoopConfig> {
        public Builder workteamArn(String var1);

        public Builder humanTaskUiArn(String var1);

        public Builder taskTitle(String var1);

        public Builder taskDescription(String var1);

        public Builder taskCount(Integer var1);

        public Builder taskAvailabilityLifetimeInSeconds(Integer var1);

        public Builder taskTimeLimitInSeconds(Integer var1);

        public Builder taskKeywords(Collection<String> var1);

        public Builder taskKeywords(String ... var1);

        public Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice var1);

        default public Builder publicWorkforceTaskPrice(Consumer<PublicWorkforceTaskPrice.Builder> publicWorkforceTaskPrice) {
            return this.publicWorkforceTaskPrice((PublicWorkforceTaskPrice)((PublicWorkforceTaskPrice.Builder)PublicWorkforceTaskPrice.builder().applyMutation(publicWorkforceTaskPrice)).build());
        }
    }
}

