/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AthenaResultCompressionType;
import software.amazon.awssdk.services.sagemaker.model.AthenaResultFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AthenaDatasetDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AthenaDatasetDefinition> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::catalog)).setter(AthenaDatasetDefinition.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::database)).setter(AthenaDatasetDefinition.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryString").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::queryString)).setter(AthenaDatasetDefinition.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::workGroup)).setter(AthenaDatasetDefinition.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3Uri").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::outputS3Uri)).setter(AthenaDatasetDefinition.setter(Builder::outputS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Uri").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::kmsKeyId)).setter(AthenaDatasetDefinition.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::outputFormatAsString)).setter(AthenaDatasetDefinition.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<String> OUTPUT_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputCompression").getter(AthenaDatasetDefinition.getter(AthenaDatasetDefinition::outputCompressionAsString)).setter(AthenaDatasetDefinition.setter(Builder::outputCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputCompression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, DATABASE_FIELD, QUERY_STRING_FIELD, WORK_GROUP_FIELD, OUTPUT_S3_URI_FIELD, KMS_KEY_ID_FIELD, OUTPUT_FORMAT_FIELD, OUTPUT_COMPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Catalog", CATALOG_FIELD);
            this.put("Database", DATABASE_FIELD);
            this.put("QueryString", QUERY_STRING_FIELD);
            this.put("WorkGroup", WORK_GROUP_FIELD);
            this.put("OutputS3Uri", OUTPUT_S3_URI_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("OutputFormat", OUTPUT_FORMAT_FIELD);
            this.put("OutputCompression", OUTPUT_COMPRESSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String catalog;
    private final String database;
    private final String queryString;
    private final String workGroup;
    private final String outputS3Uri;
    private final String kmsKeyId;
    private final String outputFormat;
    private final String outputCompression;

    private AthenaDatasetDefinition(BuilderImpl builder) {
        this.catalog = builder.catalog;
        this.database = builder.database;
        this.queryString = builder.queryString;
        this.workGroup = builder.workGroup;
        this.outputS3Uri = builder.outputS3Uri;
        this.kmsKeyId = builder.kmsKeyId;
        this.outputFormat = builder.outputFormat;
        this.outputCompression = builder.outputCompression;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String database() {
        return this.database;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final String outputS3Uri() {
        return this.outputS3Uri;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final AthenaResultFormat outputFormat() {
        return AthenaResultFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final AthenaResultCompressionType outputCompression() {
        return AthenaResultCompressionType.fromValue(this.outputCompression);
    }

    public final String outputCompressionAsString() {
        return this.outputCompression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputCompressionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaDatasetDefinition)) {
            return false;
        }
        AthenaDatasetDefinition other = (AthenaDatasetDefinition)obj;
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.outputS3Uri(), other.outputS3Uri()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.outputCompressionAsString(), other.outputCompressionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AthenaDatasetDefinition").add("Catalog", (Object)this.catalog()).add("Database", (Object)this.database()).add("QueryString", (Object)this.queryString()).add("WorkGroup", (Object)this.workGroup()).add("OutputS3Uri", (Object)this.outputS3Uri()).add("KmsKeyId", (Object)this.kmsKeyId()).add("OutputFormat", (Object)this.outputFormatAsString()).add("OutputCompression", (Object)this.outputCompressionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "OutputS3Uri": {
                return Optional.ofNullable(clazz.cast(this.outputS3Uri()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "OutputCompression": {
                return Optional.ofNullable(clazz.cast(this.outputCompressionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AthenaDatasetDefinition, T> g) {
        return obj -> g.apply((AthenaDatasetDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalog;
        private String database;
        private String queryString;
        private String workGroup;
        private String outputS3Uri;
        private String kmsKeyId;
        private String outputFormat;
        private String outputCompression;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaDatasetDefinition model) {
            this.catalog(model.catalog);
            this.database(model.database);
            this.queryString(model.queryString);
            this.workGroup(model.workGroup);
            this.outputS3Uri(model.outputS3Uri);
            this.kmsKeyId(model.kmsKeyId);
            this.outputFormat(model.outputFormat);
            this.outputCompression(model.outputCompression);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getOutputS3Uri() {
            return this.outputS3Uri;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(AthenaResultFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getOutputCompression() {
            return this.outputCompression;
        }

        public final void setOutputCompression(String outputCompression) {
            this.outputCompression = outputCompression;
        }

        @Override
        public final Builder outputCompression(String outputCompression) {
            this.outputCompression = outputCompression;
            return this;
        }

        @Override
        public final Builder outputCompression(AthenaResultCompressionType outputCompression) {
            this.outputCompression(outputCompression == null ? null : outputCompression.toString());
            return this;
        }

        public AthenaDatasetDefinition build() {
            return new AthenaDatasetDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AthenaDatasetDefinition> {
        public Builder catalog(String var1);

        public Builder database(String var1);

        public Builder queryString(String var1);

        public Builder workGroup(String var1);

        public Builder outputS3Uri(String var1);

        public Builder kmsKeyId(String var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(AthenaResultFormat var1);

        public Builder outputCompression(String var1);

        public Builder outputCompression(AthenaResultCompressionType var1);
    }
}

