/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SchedulerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterSchedulerConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateClusterSchedulerConfigRequest> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSchedulerConfigId").getter(UpdateClusterSchedulerConfigRequest.getter(UpdateClusterSchedulerConfigRequest::clusterSchedulerConfigId)).setter(UpdateClusterSchedulerConfigRequest.setter(Builder::clusterSchedulerConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build()}).build();
    private static final SdkField<Integer> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetVersion").getter(UpdateClusterSchedulerConfigRequest.getter(UpdateClusterSchedulerConfigRequest::targetVersion)).setter(UpdateClusterSchedulerConfigRequest.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<SchedulerConfig> SCHEDULER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchedulerConfig").getter(UpdateClusterSchedulerConfigRequest.getter(UpdateClusterSchedulerConfigRequest::schedulerConfig)).setter(UpdateClusterSchedulerConfigRequest.setter(Builder::schedulerConfig)).constructor(SchedulerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateClusterSchedulerConfigRequest.getter(UpdateClusterSchedulerConfigRequest::description)).setter(UpdateClusterSchedulerConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SCHEDULER_CONFIG_ID_FIELD, TARGET_VERSION_FIELD, SCHEDULER_CONFIG_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
            this.put("TargetVersion", TARGET_VERSION_FIELD);
            this.put("SchedulerConfig", SCHEDULER_CONFIG_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
        }
    });
    private final String clusterSchedulerConfigId;
    private final Integer targetVersion;
    private final SchedulerConfig schedulerConfig;
    private final String description;

    private UpdateClusterSchedulerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.targetVersion = builder.targetVersion;
        this.schedulerConfig = builder.schedulerConfig;
        this.description = builder.description;
    }

    public final String clusterSchedulerConfigId() {
        return this.clusterSchedulerConfigId;
    }

    public final Integer targetVersion() {
        return this.targetVersion;
    }

    public final SchedulerConfig schedulerConfig() {
        return this.schedulerConfig;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSchedulerConfigRequest)) {
            return false;
        }
        UpdateClusterSchedulerConfigRequest other = (UpdateClusterSchedulerConfigRequest)((Object)obj);
        return Objects.equals(this.clusterSchedulerConfigId(), other.clusterSchedulerConfigId()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.schedulerConfig(), other.schedulerConfig()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterSchedulerConfigRequest").add("ClusterSchedulerConfigId", (Object)this.clusterSchedulerConfigId()).add("TargetVersion", (Object)this.targetVersion()).add("SchedulerConfig", (Object)this.schedulerConfig()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSchedulerConfigId": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigId()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "SchedulerConfig": {
                return Optional.ofNullable(clazz.cast(this.schedulerConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSchedulerConfigRequest, T> g) {
        return obj -> g.apply((UpdateClusterSchedulerConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterSchedulerConfigId;
        private Integer targetVersion;
        private SchedulerConfig schedulerConfig;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSchedulerConfigRequest model) {
            super(model);
            this.clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            this.targetVersion(model.targetVersion);
            this.schedulerConfig(model.schedulerConfig);
            this.description(model.description);
        }

        public final String getClusterSchedulerConfigId() {
            return this.clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final Integer getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(Integer targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(Integer targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final SchedulerConfig.Builder getSchedulerConfig() {
            return this.schedulerConfig != null ? this.schedulerConfig.toBuilder() : null;
        }

        public final void setSchedulerConfig(SchedulerConfig.BuilderImpl schedulerConfig) {
            this.schedulerConfig = schedulerConfig != null ? schedulerConfig.build() : null;
        }

        @Override
        public final Builder schedulerConfig(SchedulerConfig schedulerConfig) {
            this.schedulerConfig = schedulerConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterSchedulerConfigRequest build() {
            return new UpdateClusterSchedulerConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterSchedulerConfigRequest> {
        public Builder clusterSchedulerConfigId(String var1);

        public Builder targetVersion(Integer var1);

        public Builder schedulerConfig(SchedulerConfig var1);

        default public Builder schedulerConfig(Consumer<SchedulerConfig.Builder> schedulerConfig) {
            return this.schedulerConfig((SchedulerConfig)((SchedulerConfig.Builder)SchedulerConfig.builder().applyMutation(schedulerConfig)).build());
        }

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

