/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ImageVersionStatus;
import software.amazon.awssdk.services.sagemaker.model.JobType;
import software.amazon.awssdk.services.sagemaker.model.Processor;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.VendorGuidance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageVersionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeImageVersionResponse> {
    private static final SdkField<String> BASE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseImage").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::baseImage)).setter(DescribeImageVersionResponse.setter(Builder::baseImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImage").build()}).build();
    private static final SdkField<String> CONTAINER_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerImage").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::containerImage)).setter(DescribeImageVersionResponse.setter(Builder::containerImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerImage").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::creationTime)).setter(DescribeImageVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::failureReason)).setter(DescribeImageVersionResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageArn").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::imageArn)).setter(DescribeImageVersionResponse.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> IMAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageVersionArn").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::imageVersionArn)).setter(DescribeImageVersionResponse.setter(Builder::imageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionArn").build()}).build();
    private static final SdkField<String> IMAGE_VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageVersionStatus").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::imageVersionStatusAsString)).setter(DescribeImageVersionResponse.setter(Builder::imageVersionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::lastModifiedTime)).setter(DescribeImageVersionResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Version").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::version)).setter(DescribeImageVersionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorGuidance").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::vendorGuidanceAsString)).setter(DescribeImageVersionResponse.setter(Builder::vendorGuidance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorGuidance").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::jobTypeAsString)).setter(DescribeImageVersionResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> ML_FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLFramework").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::mlFramework)).setter(DescribeImageVersionResponse.setter(Builder::mlFramework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLFramework").build()}).build();
    private static final SdkField<String> PROGRAMMING_LANG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgrammingLang").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::programmingLang)).setter(DescribeImageVersionResponse.setter(Builder::programmingLang)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLang").build()}).build();
    private static final SdkField<String> PROCESSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Processor").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::processorAsString)).setter(DescribeImageVersionResponse.setter(Builder::processor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processor").build()}).build();
    private static final SdkField<Boolean> HOROVOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Horovod").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::horovod)).setter(DescribeImageVersionResponse.setter(Builder::horovod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Horovod").build()}).build();
    private static final SdkField<String> RELEASE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseNotes").getter(DescribeImageVersionResponse.getter(DescribeImageVersionResponse::releaseNotes)).setter(DescribeImageVersionResponse.setter(Builder::releaseNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseNotes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_IMAGE_FIELD, CONTAINER_IMAGE_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, IMAGE_ARN_FIELD, IMAGE_VERSION_ARN_FIELD, IMAGE_VERSION_STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, VERSION_FIELD, VENDOR_GUIDANCE_FIELD, JOB_TYPE_FIELD, ML_FRAMEWORK_FIELD, PROGRAMMING_LANG_FIELD, PROCESSOR_FIELD, HOROVOD_FIELD, RELEASE_NOTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BaseImage", BASE_IMAGE_FIELD);
            this.put("ContainerImage", CONTAINER_IMAGE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("ImageArn", IMAGE_ARN_FIELD);
            this.put("ImageVersionArn", IMAGE_VERSION_ARN_FIELD);
            this.put("ImageVersionStatus", IMAGE_VERSION_STATUS_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("Version", VERSION_FIELD);
            this.put("VendorGuidance", VENDOR_GUIDANCE_FIELD);
            this.put("JobType", JOB_TYPE_FIELD);
            this.put("MLFramework", ML_FRAMEWORK_FIELD);
            this.put("ProgrammingLang", PROGRAMMING_LANG_FIELD);
            this.put("Processor", PROCESSOR_FIELD);
            this.put("Horovod", HOROVOD_FIELD);
            this.put("ReleaseNotes", RELEASE_NOTES_FIELD);
        }
    });
    private final String baseImage;
    private final String containerImage;
    private final Instant creationTime;
    private final String failureReason;
    private final String imageArn;
    private final String imageVersionArn;
    private final String imageVersionStatus;
    private final Instant lastModifiedTime;
    private final Integer version;
    private final String vendorGuidance;
    private final String jobType;
    private final String mlFramework;
    private final String programmingLang;
    private final String processor;
    private final Boolean horovod;
    private final String releaseNotes;

    private DescribeImageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.baseImage = builder.baseImage;
        this.containerImage = builder.containerImage;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.imageArn = builder.imageArn;
        this.imageVersionArn = builder.imageVersionArn;
        this.imageVersionStatus = builder.imageVersionStatus;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.version = builder.version;
        this.vendorGuidance = builder.vendorGuidance;
        this.jobType = builder.jobType;
        this.mlFramework = builder.mlFramework;
        this.programmingLang = builder.programmingLang;
        this.processor = builder.processor;
        this.horovod = builder.horovod;
        this.releaseNotes = builder.releaseNotes;
    }

    public final String baseImage() {
        return this.baseImage;
    }

    public final String containerImage() {
        return this.containerImage;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String imageArn() {
        return this.imageArn;
    }

    public final String imageVersionArn() {
        return this.imageVersionArn;
    }

    public final ImageVersionStatus imageVersionStatus() {
        return ImageVersionStatus.fromValue(this.imageVersionStatus);
    }

    public final String imageVersionStatusAsString() {
        return this.imageVersionStatus;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Integer version() {
        return this.version;
    }

    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(this.vendorGuidance);
    }

    public final String vendorGuidanceAsString() {
        return this.vendorGuidance;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String mlFramework() {
        return this.mlFramework;
    }

    public final String programmingLang() {
        return this.programmingLang;
    }

    public final Processor processor() {
        return Processor.fromValue(this.processor);
    }

    public final String processorAsString() {
        return this.processor;
    }

    public final Boolean horovod() {
        return this.horovod;
    }

    public final String releaseNotes() {
        return this.releaseNotes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageVersionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlFramework());
        hashCode = 31 * hashCode + Objects.hashCode(this.programmingLang());
        hashCode = 31 * hashCode + Objects.hashCode(this.processorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.horovod());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseNotes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageVersionResponse)) {
            return false;
        }
        DescribeImageVersionResponse other = (DescribeImageVersionResponse)((Object)obj);
        return Objects.equals(this.baseImage(), other.baseImage()) && Objects.equals(this.containerImage(), other.containerImage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.imageVersionArn(), other.imageVersionArn()) && Objects.equals(this.imageVersionStatusAsString(), other.imageVersionStatusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.vendorGuidanceAsString(), other.vendorGuidanceAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.mlFramework(), other.mlFramework()) && Objects.equals(this.programmingLang(), other.programmingLang()) && Objects.equals(this.processorAsString(), other.processorAsString()) && Objects.equals(this.horovod(), other.horovod()) && Objects.equals(this.releaseNotes(), other.releaseNotes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageVersionResponse").add("BaseImage", (Object)this.baseImage()).add("ContainerImage", (Object)this.containerImage()).add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("ImageArn", (Object)this.imageArn()).add("ImageVersionArn", (Object)this.imageVersionArn()).add("ImageVersionStatus", (Object)this.imageVersionStatusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Version", (Object)this.version()).add("VendorGuidance", (Object)this.vendorGuidanceAsString()).add("JobType", (Object)this.jobTypeAsString()).add("MLFramework", (Object)this.mlFramework()).add("ProgrammingLang", (Object)this.programmingLang()).add("Processor", (Object)this.processorAsString()).add("Horovod", (Object)this.horovod()).add("ReleaseNotes", (Object)this.releaseNotes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseImage": {
                return Optional.ofNullable(clazz.cast(this.baseImage()));
            }
            case "ContainerImage": {
                return Optional.ofNullable(clazz.cast(this.containerImage()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "ImageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.imageVersionArn()));
            }
            case "ImageVersionStatus": {
                return Optional.ofNullable(clazz.cast(this.imageVersionStatusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "VendorGuidance": {
                return Optional.ofNullable(clazz.cast(this.vendorGuidanceAsString()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "MLFramework": {
                return Optional.ofNullable(clazz.cast(this.mlFramework()));
            }
            case "ProgrammingLang": {
                return Optional.ofNullable(clazz.cast(this.programmingLang()));
            }
            case "Processor": {
                return Optional.ofNullable(clazz.cast(this.processorAsString()));
            }
            case "Horovod": {
                return Optional.ofNullable(clazz.cast(this.horovod()));
            }
            case "ReleaseNotes": {
                return Optional.ofNullable(clazz.cast(this.releaseNotes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageVersionResponse, T> g) {
        return obj -> g.apply((DescribeImageVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String baseImage;
        private String containerImage;
        private Instant creationTime;
        private String failureReason;
        private String imageArn;
        private String imageVersionArn;
        private String imageVersionStatus;
        private Instant lastModifiedTime;
        private Integer version;
        private String vendorGuidance;
        private String jobType;
        private String mlFramework;
        private String programmingLang;
        private String processor;
        private Boolean horovod;
        private String releaseNotes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageVersionResponse model) {
            super(model);
            this.baseImage(model.baseImage);
            this.containerImage(model.containerImage);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.imageArn(model.imageArn);
            this.imageVersionArn(model.imageVersionArn);
            this.imageVersionStatus(model.imageVersionStatus);
            this.lastModifiedTime(model.lastModifiedTime);
            this.version(model.version);
            this.vendorGuidance(model.vendorGuidance);
            this.jobType(model.jobType);
            this.mlFramework(model.mlFramework);
            this.programmingLang(model.programmingLang);
            this.processor(model.processor);
            this.horovod(model.horovod);
            this.releaseNotes(model.releaseNotes);
        }

        public final String getBaseImage() {
            return this.baseImage;
        }

        public final void setBaseImage(String baseImage) {
            this.baseImage = baseImage;
        }

        @Override
        public final Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public final String getContainerImage() {
            return this.containerImage;
        }

        public final void setContainerImage(String containerImage) {
            this.containerImage = containerImage;
        }

        @Override
        public final Builder containerImage(String containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getImageVersionArn() {
            return this.imageVersionArn;
        }

        public final void setImageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
        }

        @Override
        public final Builder imageVersionArn(String imageVersionArn) {
            this.imageVersionArn = imageVersionArn;
            return this;
        }

        public final String getImageVersionStatus() {
            return this.imageVersionStatus;
        }

        public final void setImageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
        }

        @Override
        public final Builder imageVersionStatus(String imageVersionStatus) {
            this.imageVersionStatus = imageVersionStatus;
            return this;
        }

        @Override
        public final Builder imageVersionStatus(ImageVersionStatus imageVersionStatus) {
            this.imageVersionStatus(imageVersionStatus == null ? null : imageVersionStatus.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getVendorGuidance() {
            return this.vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getMlFramework() {
            return this.mlFramework;
        }

        public final void setMlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
        }

        @Override
        public final Builder mlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
            return this;
        }

        public final String getProgrammingLang() {
            return this.programmingLang;
        }

        public final void setProgrammingLang(String programmingLang) {
            this.programmingLang = programmingLang;
        }

        @Override
        public final Builder programmingLang(String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        public final String getProcessor() {
            return this.processor;
        }

        public final void setProcessor(String processor) {
            this.processor = processor;
        }

        @Override
        public final Builder processor(String processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public final Builder processor(Processor processor) {
            this.processor(processor == null ? null : processor.toString());
            return this;
        }

        public final Boolean getHorovod() {
            return this.horovod;
        }

        public final void setHorovod(Boolean horovod) {
            this.horovod = horovod;
        }

        @Override
        public final Builder horovod(Boolean horovod) {
            this.horovod = horovod;
            return this;
        }

        public final String getReleaseNotes() {
            return this.releaseNotes;
        }

        public final void setReleaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
        }

        @Override
        public final Builder releaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        @Override
        public DescribeImageVersionResponse build() {
            return new DescribeImageVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageVersionResponse> {
        public Builder baseImage(String var1);

        public Builder containerImage(String var1);

        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder imageArn(String var1);

        public Builder imageVersionArn(String var1);

        public Builder imageVersionStatus(String var1);

        public Builder imageVersionStatus(ImageVersionStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder version(Integer var1);

        public Builder vendorGuidance(String var1);

        public Builder vendorGuidance(VendorGuidance var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder mlFramework(String var1);

        public Builder programmingLang(String var1);

        public Builder processor(String var1);

        public Builder processor(Processor var1);

        public Builder horovod(Boolean var1);

        public Builder releaseNotes(String var1);
    }
}

