/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComputeQuotaRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeComputeQuotaRequest> {
    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaId").getter(DescribeComputeQuotaRequest.getter(DescribeComputeQuotaRequest::computeQuotaId)).setter(DescribeComputeQuotaRequest.setter(Builder::computeQuotaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()}).build();
    private static final SdkField<Integer> COMPUTE_QUOTA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ComputeQuotaVersion").getter(DescribeComputeQuotaRequest.getter(DescribeComputeQuotaRequest::computeQuotaVersion)).setter(DescribeComputeQuotaRequest.setter(Builder::computeQuotaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ID_FIELD, COMPUTE_QUOTA_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
            this.put("ComputeQuotaVersion", COMPUTE_QUOTA_VERSION_FIELD);
        }
    });
    private final String computeQuotaId;
    private final Integer computeQuotaVersion;

    private DescribeComputeQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.computeQuotaId = builder.computeQuotaId;
        this.computeQuotaVersion = builder.computeQuotaVersion;
    }

    public final String computeQuotaId() {
        return this.computeQuotaId;
    }

    public final Integer computeQuotaVersion() {
        return this.computeQuotaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeQuotaRequest)) {
            return false;
        }
        DescribeComputeQuotaRequest other = (DescribeComputeQuotaRequest)((Object)obj);
        return Objects.equals(this.computeQuotaId(), other.computeQuotaId()) && Objects.equals(this.computeQuotaVersion(), other.computeQuotaVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComputeQuotaRequest").add("ComputeQuotaId", (Object)this.computeQuotaId()).add("ComputeQuotaVersion", (Object)this.computeQuotaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaId": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaId()));
            }
            case "ComputeQuotaVersion": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputeQuotaRequest, T> g) {
        return obj -> g.apply((DescribeComputeQuotaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String computeQuotaId;
        private Integer computeQuotaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeQuotaRequest model) {
            super(model);
            this.computeQuotaId(model.computeQuotaId);
            this.computeQuotaVersion(model.computeQuotaVersion);
        }

        public final String getComputeQuotaId() {
            return this.computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        public final Integer getComputeQuotaVersion() {
            return this.computeQuotaVersion;
        }

        public final void setComputeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
        }

        @Override
        public final Builder computeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputeQuotaRequest build() {
            return new DescribeComputeQuotaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComputeQuotaRequest> {
        public Builder computeQuotaId(String var1);

        public Builder computeQuotaVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

