/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputeQuotaResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, CreateComputeQuotaResponse> {
    private static final SdkField<String> COMPUTE_QUOTA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaArn").getter(CreateComputeQuotaResponse.getter(CreateComputeQuotaResponse::computeQuotaArn)).setter(CreateComputeQuotaResponse.setter(Builder::computeQuotaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaArn").build()}).build();
    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeQuotaId").getter(CreateComputeQuotaResponse.getter(CreateComputeQuotaResponse::computeQuotaId)).setter(CreateComputeQuotaResponse.setter(Builder::computeQuotaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ARN_FIELD, COMPUTE_QUOTA_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComputeQuotaArn", COMPUTE_QUOTA_ARN_FIELD);
            this.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
        }
    });
    private final String computeQuotaArn;
    private final String computeQuotaId;

    private CreateComputeQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.computeQuotaArn = builder.computeQuotaArn;
        this.computeQuotaId = builder.computeQuotaId;
    }

    public final String computeQuotaArn() {
        return this.computeQuotaArn;
    }

    public final String computeQuotaId() {
        return this.computeQuotaId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeQuotaId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeQuotaResponse)) {
            return false;
        }
        CreateComputeQuotaResponse other = (CreateComputeQuotaResponse)((Object)obj);
        return Objects.equals(this.computeQuotaArn(), other.computeQuotaArn()) && Objects.equals(this.computeQuotaId(), other.computeQuotaId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComputeQuotaResponse").add("ComputeQuotaArn", (Object)this.computeQuotaArn()).add("ComputeQuotaId", (Object)this.computeQuotaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaArn": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaArn()));
            }
            case "ComputeQuotaId": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeQuotaResponse, T> g) {
        return obj -> g.apply((CreateComputeQuotaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String computeQuotaArn;
        private String computeQuotaId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeQuotaResponse model) {
            super(model);
            this.computeQuotaArn(model.computeQuotaArn);
            this.computeQuotaId(model.computeQuotaId);
        }

        public final String getComputeQuotaArn() {
            return this.computeQuotaArn;
        }

        public final void setComputeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
        }

        @Override
        public final Builder computeQuotaArn(String computeQuotaArn) {
            this.computeQuotaArn = computeQuotaArn;
            return this;
        }

        public final String getComputeQuotaId() {
            return this.computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        @Override
        public CreateComputeQuotaResponse build() {
            return new CreateComputeQuotaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputeQuotaResponse> {
        public Builder computeQuotaArn(String var1);

        public Builder computeQuotaId(String var1);
    }
}

