/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelClientConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelClientConfig> {
    private static final SdkField<Integer> INVOCATIONS_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvocationsTimeoutInSeconds").getter(ModelClientConfig.getter(ModelClientConfig::invocationsTimeoutInSeconds)).setter(ModelClientConfig.setter(Builder::invocationsTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationsTimeoutInSeconds").build()}).build();
    private static final SdkField<Integer> INVOCATIONS_MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvocationsMaxRetries").getter(ModelClientConfig.getter(ModelClientConfig::invocationsMaxRetries)).setter(ModelClientConfig.setter(Builder::invocationsMaxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationsMaxRetries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATIONS_TIMEOUT_IN_SECONDS_FIELD, INVOCATIONS_MAX_RETRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InvocationsTimeoutInSeconds", INVOCATIONS_TIMEOUT_IN_SECONDS_FIELD);
            this.put("InvocationsMaxRetries", INVOCATIONS_MAX_RETRIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer invocationsTimeoutInSeconds;
    private final Integer invocationsMaxRetries;

    private ModelClientConfig(BuilderImpl builder) {
        this.invocationsTimeoutInSeconds = builder.invocationsTimeoutInSeconds;
        this.invocationsMaxRetries = builder.invocationsMaxRetries;
    }

    public final Integer invocationsTimeoutInSeconds() {
        return this.invocationsTimeoutInSeconds;
    }

    public final Integer invocationsMaxRetries() {
        return this.invocationsMaxRetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationsTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationsMaxRetries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelClientConfig)) {
            return false;
        }
        ModelClientConfig other = (ModelClientConfig)obj;
        return Objects.equals(this.invocationsTimeoutInSeconds(), other.invocationsTimeoutInSeconds()) && Objects.equals(this.invocationsMaxRetries(), other.invocationsMaxRetries());
    }

    public final String toString() {
        return ToString.builder((String)"ModelClientConfig").add("InvocationsTimeoutInSeconds", (Object)this.invocationsTimeoutInSeconds()).add("InvocationsMaxRetries", (Object)this.invocationsMaxRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvocationsTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.invocationsTimeoutInSeconds()));
            }
            case "InvocationsMaxRetries": {
                return Optional.ofNullable(clazz.cast(this.invocationsMaxRetries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelClientConfig, T> g) {
        return obj -> g.apply((ModelClientConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer invocationsTimeoutInSeconds;
        private Integer invocationsMaxRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelClientConfig model) {
            this.invocationsTimeoutInSeconds(model.invocationsTimeoutInSeconds);
            this.invocationsMaxRetries(model.invocationsMaxRetries);
        }

        public final Integer getInvocationsTimeoutInSeconds() {
            return this.invocationsTimeoutInSeconds;
        }

        public final void setInvocationsTimeoutInSeconds(Integer invocationsTimeoutInSeconds) {
            this.invocationsTimeoutInSeconds = invocationsTimeoutInSeconds;
        }

        @Override
        public final Builder invocationsTimeoutInSeconds(Integer invocationsTimeoutInSeconds) {
            this.invocationsTimeoutInSeconds = invocationsTimeoutInSeconds;
            return this;
        }

        public final Integer getInvocationsMaxRetries() {
            return this.invocationsMaxRetries;
        }

        public final void setInvocationsMaxRetries(Integer invocationsMaxRetries) {
            this.invocationsMaxRetries = invocationsMaxRetries;
        }

        @Override
        public final Builder invocationsMaxRetries(Integer invocationsMaxRetries) {
            this.invocationsMaxRetries = invocationsMaxRetries;
            return this;
        }

        public ModelClientConfig build() {
            return new ModelClientConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelClientConfig> {
        public Builder invocationsTimeoutInSeconds(Integer var1);

        public Builder invocationsMaxRetries(Integer var1);
    }
}

