/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.HubSortBy;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHubsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListHubsRequest> {
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListHubsRequest.getter(ListHubsRequest::nameContains)).setter(ListHubsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListHubsRequest.getter(ListHubsRequest::creationTimeBefore)).setter(ListHubsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListHubsRequest.getter(ListHubsRequest::creationTimeAfter)).setter(ListHubsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeBefore").getter(ListHubsRequest.getter(ListHubsRequest::lastModifiedTimeBefore)).setter(ListHubsRequest.setter(Builder::lastModifiedTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTimeAfter").getter(ListHubsRequest.getter(ListHubsRequest::lastModifiedTimeAfter)).setter(ListHubsRequest.setter(Builder::lastModifiedTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListHubsRequest.getter(ListHubsRequest::sortByAsString)).setter(ListHubsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListHubsRequest.getter(ListHubsRequest::sortOrderAsString)).setter(ListHubsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListHubsRequest.getter(ListHubsRequest::maxResults)).setter(ListHubsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHubsRequest.getter(ListHubsRequest::nextToken)).setter(ListHubsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_CONTAINS_FIELD, CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NameContains", NAME_CONTAINS_FIELD);
            this.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
            this.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
            this.put("LastModifiedTimeBefore", LAST_MODIFIED_TIME_BEFORE_FIELD);
            this.put("LastModifiedTimeAfter", LAST_MODIFIED_TIME_AFTER_FIELD);
            this.put("SortBy", SORT_BY_FIELD);
            this.put("SortOrder", SORT_ORDER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String nameContains;
    private final Instant creationTimeBefore;
    private final Instant creationTimeAfter;
    private final Instant lastModifiedTimeBefore;
    private final Instant lastModifiedTimeAfter;
    private final String sortBy;
    private final String sortOrder;
    private final Integer maxResults;
    private final String nextToken;

    private ListHubsRequest(BuilderImpl builder) {
        super(builder);
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant lastModifiedTimeBefore() {
        return this.lastModifiedTimeBefore;
    }

    public final Instant lastModifiedTimeAfter() {
        return this.lastModifiedTimeAfter;
    }

    public final HubSortBy sortBy() {
        return HubSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHubsRequest)) {
            return false;
        }
        ListHubsRequest other = (ListHubsRequest)((Object)obj);
        return Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.lastModifiedTimeBefore(), other.lastModifiedTimeBefore()) && Objects.equals(this.lastModifiedTimeAfter(), other.lastModifiedTimeAfter()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHubsRequest").add("NameContains", (Object)this.nameContains()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("LastModifiedTimeBefore", (Object)this.lastModifiedTimeBefore()).add("LastModifiedTimeAfter", (Object)this.lastModifiedTimeAfter()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "LastModifiedTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeBefore()));
            }
            case "LastModifiedTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeAfter()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHubsRequest, T> g) {
        return obj -> g.apply((ListHubsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nameContains;
        private Instant creationTimeBefore;
        private Instant creationTimeAfter;
        private Instant lastModifiedTimeBefore;
        private Instant lastModifiedTimeAfter;
        private String sortBy;
        private String sortOrder;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHubsRequest model) {
            super(model);
            this.nameContains(model.nameContains);
            this.creationTimeBefore(model.creationTimeBefore);
            this.creationTimeAfter(model.creationTimeAfter);
            this.lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            this.lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return this.lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return this.lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(HubSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHubsRequest build() {
            return new ListHubsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHubsRequest> {
        public Builder nameContains(String var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder lastModifiedTimeBefore(Instant var1);

        public Builder lastModifiedTimeAfter(Instant var1);

        public Builder sortBy(String var1);

        public Builder sortBy(HubSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

