/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceSettings> {
    private static final SdkField<String> S3_ARTIFACT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ArtifactPath").getter(WorkspaceSettings.getter(WorkspaceSettings::s3ArtifactPath)).setter(WorkspaceSettings.setter(Builder::s3ArtifactPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ArtifactPath").build()}).build();
    private static final SdkField<String> S3_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KmsKeyId").getter(WorkspaceSettings.getter(WorkspaceSettings::s3KmsKeyId)).setter(WorkspaceSettings.setter(Builder::s3KmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ARTIFACT_PATH_FIELD, S3_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("S3ArtifactPath", S3_ARTIFACT_PATH_FIELD);
            this.put("S3KmsKeyId", S3_KMS_KEY_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3ArtifactPath;
    private final String s3KmsKeyId;

    private WorkspaceSettings(BuilderImpl builder) {
        this.s3ArtifactPath = builder.s3ArtifactPath;
        this.s3KmsKeyId = builder.s3KmsKeyId;
    }

    public final String s3ArtifactPath() {
        return this.s3ArtifactPath;
    }

    public final String s3KmsKeyId() {
        return this.s3KmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ArtifactPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceSettings)) {
            return false;
        }
        WorkspaceSettings other = (WorkspaceSettings)obj;
        return Objects.equals(this.s3ArtifactPath(), other.s3ArtifactPath()) && Objects.equals(this.s3KmsKeyId(), other.s3KmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceSettings").add("S3ArtifactPath", (Object)this.s3ArtifactPath()).add("S3KmsKeyId", (Object)this.s3KmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3ArtifactPath": {
                return Optional.ofNullable(clazz.cast(this.s3ArtifactPath()));
            }
            case "S3KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.s3KmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceSettings, T> g) {
        return obj -> g.apply((WorkspaceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3ArtifactPath;
        private String s3KmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceSettings model) {
            this.s3ArtifactPath(model.s3ArtifactPath);
            this.s3KmsKeyId(model.s3KmsKeyId);
        }

        public final String getS3ArtifactPath() {
            return this.s3ArtifactPath;
        }

        public final void setS3ArtifactPath(String s3ArtifactPath) {
            this.s3ArtifactPath = s3ArtifactPath;
        }

        @Override
        public final Builder s3ArtifactPath(String s3ArtifactPath) {
            this.s3ArtifactPath = s3ArtifactPath;
            return this;
        }

        public final String getS3KmsKeyId() {
            return this.s3KmsKeyId;
        }

        public final void setS3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
        }

        @Override
        public final Builder s3KmsKeyId(String s3KmsKeyId) {
            this.s3KmsKeyId = s3KmsKeyId;
            return this;
        }

        public WorkspaceSettings build() {
            return new WorkspaceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceSettings> {
        public Builder s3ArtifactPath(String var1);

        public Builder s3KmsKeyId(String var1);
    }
}

