/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeviceNamesCopier;
import software.amazon.awssdk.services.sagemaker.model.DeviceSubsetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSelectionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceSelectionConfig> {
    private static final SdkField<String> DEVICE_SUBSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceSubsetType").getter(DeviceSelectionConfig.getter(DeviceSelectionConfig::deviceSubsetTypeAsString)).setter(DeviceSelectionConfig.setter(Builder::deviceSubsetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSubsetType").build()}).build();
    private static final SdkField<Integer> PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Percentage").getter(DeviceSelectionConfig.getter(DeviceSelectionConfig::percentage)).setter(DeviceSelectionConfig.setter(Builder::percentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()}).build();
    private static final SdkField<List<String>> DEVICE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceNames").getter(DeviceSelectionConfig.getter(DeviceSelectionConfig::deviceNames)).setter(DeviceSelectionConfig.setter(Builder::deviceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceNameContains").getter(DeviceSelectionConfig.getter(DeviceSelectionConfig::deviceNameContains)).setter(DeviceSelectionConfig.setter(Builder::deviceNameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceNameContains").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_SUBSET_TYPE_FIELD, PERCENTAGE_FIELD, DEVICE_NAMES_FIELD, DEVICE_NAME_CONTAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeviceSubsetType", DEVICE_SUBSET_TYPE_FIELD);
            this.put("Percentage", PERCENTAGE_FIELD);
            this.put("DeviceNames", DEVICE_NAMES_FIELD);
            this.put("DeviceNameContains", DEVICE_NAME_CONTAINS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deviceSubsetType;
    private final Integer percentage;
    private final List<String> deviceNames;
    private final String deviceNameContains;

    private DeviceSelectionConfig(BuilderImpl builder) {
        this.deviceSubsetType = builder.deviceSubsetType;
        this.percentage = builder.percentage;
        this.deviceNames = builder.deviceNames;
        this.deviceNameContains = builder.deviceNameContains;
    }

    public final DeviceSubsetType deviceSubsetType() {
        return DeviceSubsetType.fromValue(this.deviceSubsetType);
    }

    public final String deviceSubsetTypeAsString() {
        return this.deviceSubsetType;
    }

    public final Integer percentage() {
        return this.percentage;
    }

    public final boolean hasDeviceNames() {
        return this.deviceNames != null && !(this.deviceNames instanceof SdkAutoConstructList);
    }

    public final List<String> deviceNames() {
        return this.deviceNames;
    }

    public final String deviceNameContains() {
        return this.deviceNameContains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSubsetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceNames() ? this.deviceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceNameContains());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSelectionConfig)) {
            return false;
        }
        DeviceSelectionConfig other = (DeviceSelectionConfig)obj;
        return Objects.equals(this.deviceSubsetTypeAsString(), other.deviceSubsetTypeAsString()) && Objects.equals(this.percentage(), other.percentage()) && this.hasDeviceNames() == other.hasDeviceNames() && Objects.equals(this.deviceNames(), other.deviceNames()) && Objects.equals(this.deviceNameContains(), other.deviceNameContains());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceSelectionConfig").add("DeviceSubsetType", (Object)this.deviceSubsetTypeAsString()).add("Percentage", (Object)this.percentage()).add("DeviceNames", this.hasDeviceNames() ? this.deviceNames() : null).add("DeviceNameContains", (Object)this.deviceNameContains()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceSubsetType": {
                return Optional.ofNullable(clazz.cast(this.deviceSubsetTypeAsString()));
            }
            case "Percentage": {
                return Optional.ofNullable(clazz.cast(this.percentage()));
            }
            case "DeviceNames": {
                return Optional.ofNullable(clazz.cast(this.deviceNames()));
            }
            case "DeviceNameContains": {
                return Optional.ofNullable(clazz.cast(this.deviceNameContains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSelectionConfig, T> g) {
        return obj -> g.apply((DeviceSelectionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceSubsetType;
        private Integer percentage;
        private List<String> deviceNames = DefaultSdkAutoConstructList.getInstance();
        private String deviceNameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSelectionConfig model) {
            this.deviceSubsetType(model.deviceSubsetType);
            this.percentage(model.percentage);
            this.deviceNames(model.deviceNames);
            this.deviceNameContains(model.deviceNameContains);
        }

        public final String getDeviceSubsetType() {
            return this.deviceSubsetType;
        }

        public final void setDeviceSubsetType(String deviceSubsetType) {
            this.deviceSubsetType = deviceSubsetType;
        }

        @Override
        public final Builder deviceSubsetType(String deviceSubsetType) {
            this.deviceSubsetType = deviceSubsetType;
            return this;
        }

        @Override
        public final Builder deviceSubsetType(DeviceSubsetType deviceSubsetType) {
            this.deviceSubsetType(deviceSubsetType == null ? null : deviceSubsetType.toString());
            return this;
        }

        public final Integer getPercentage() {
            return this.percentage;
        }

        public final void setPercentage(Integer percentage) {
            this.percentage = percentage;
        }

        @Override
        public final Builder percentage(Integer percentage) {
            this.percentage = percentage;
            return this;
        }

        public final Collection<String> getDeviceNames() {
            if (this.deviceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceNames;
        }

        public final void setDeviceNames(Collection<String> deviceNames) {
            this.deviceNames = DeviceNamesCopier.copy(deviceNames);
        }

        @Override
        public final Builder deviceNames(Collection<String> deviceNames) {
            this.deviceNames = DeviceNamesCopier.copy(deviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceNames(String ... deviceNames) {
            this.deviceNames(Arrays.asList(deviceNames));
            return this;
        }

        public final String getDeviceNameContains() {
            return this.deviceNameContains;
        }

        public final void setDeviceNameContains(String deviceNameContains) {
            this.deviceNameContains = deviceNameContains;
        }

        @Override
        public final Builder deviceNameContains(String deviceNameContains) {
            this.deviceNameContains = deviceNameContains;
            return this;
        }

        public DeviceSelectionConfig build() {
            return new DeviceSelectionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceSelectionConfig> {
        public Builder deviceSubsetType(String var1);

        public Builder deviceSubsetType(DeviceSubsetType var1);

        public Builder percentage(Integer var1);

        public Builder deviceNames(Collection<String> var1);

        public Builder deviceNames(String ... var1);

        public Builder deviceNameContains(String var1);
    }
}

