/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration;
import software.amazon.awssdk.services.sagemaker.model.ModelConfiguration;
import software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceRecommendation> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(InferenceRecommendation.getter(InferenceRecommendation::recommendationId)).setter(InferenceRecommendation.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<RecommendationMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metrics").getter(InferenceRecommendation.getter(InferenceRecommendation::metrics)).setter(InferenceRecommendation.setter(Builder::metrics)).constructor(RecommendationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()}).build();
    private static final SdkField<EndpointOutputConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(InferenceRecommendation.getter(InferenceRecommendation::endpointConfiguration)).setter(InferenceRecommendation.setter(Builder::endpointConfiguration)).constructor(EndpointOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build()}).build();
    private static final SdkField<ModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelConfiguration").getter(InferenceRecommendation.getter(InferenceRecommendation::modelConfiguration)).setter(InferenceRecommendation.setter(Builder::modelConfiguration)).constructor(ModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfiguration").build()}).build();
    private static final SdkField<Instant> INVOCATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvocationEndTime").getter(InferenceRecommendation.getter(InferenceRecommendation::invocationEndTime)).setter(InferenceRecommendation.setter(Builder::invocationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationEndTime").build()}).build();
    private static final SdkField<Instant> INVOCATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvocationStartTime").getter(InferenceRecommendation.getter(InferenceRecommendation::invocationStartTime)).setter(InferenceRecommendation.setter(Builder::invocationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, METRICS_FIELD, ENDPOINT_CONFIGURATION_FIELD, MODEL_CONFIGURATION_FIELD, INVOCATION_END_TIME_FIELD, INVOCATION_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RecommendationId", RECOMMENDATION_ID_FIELD);
            this.put("Metrics", METRICS_FIELD);
            this.put("EndpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
            this.put("ModelConfiguration", MODEL_CONFIGURATION_FIELD);
            this.put("InvocationEndTime", INVOCATION_END_TIME_FIELD);
            this.put("InvocationStartTime", INVOCATION_START_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String recommendationId;
    private final RecommendationMetrics metrics;
    private final EndpointOutputConfiguration endpointConfiguration;
    private final ModelConfiguration modelConfiguration;
    private final Instant invocationEndTime;
    private final Instant invocationStartTime;

    private InferenceRecommendation(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.metrics = builder.metrics;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.modelConfiguration = builder.modelConfiguration;
        this.invocationEndTime = builder.invocationEndTime;
        this.invocationStartTime = builder.invocationStartTime;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final RecommendationMetrics metrics() {
        return this.metrics;
    }

    public final EndpointOutputConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final ModelConfiguration modelConfiguration() {
        return this.modelConfiguration;
    }

    public final Instant invocationEndTime() {
        return this.invocationEndTime;
    }

    public final Instant invocationStartTime() {
        return this.invocationStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceRecommendation)) {
            return false;
        }
        InferenceRecommendation other = (InferenceRecommendation)obj;
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.modelConfiguration(), other.modelConfiguration()) && Objects.equals(this.invocationEndTime(), other.invocationEndTime()) && Objects.equals(this.invocationStartTime(), other.invocationStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceRecommendation").add("RecommendationId", (Object)this.recommendationId()).add("Metrics", (Object)this.metrics()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("ModelConfiguration", (Object)this.modelConfiguration()).add("InvocationEndTime", (Object)this.invocationEndTime()).add("InvocationStartTime", (Object)this.invocationStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "ModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelConfiguration()));
            }
            case "InvocationEndTime": {
                return Optional.ofNullable(clazz.cast(this.invocationEndTime()));
            }
            case "InvocationStartTime": {
                return Optional.ofNullable(clazz.cast(this.invocationStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceRecommendation, T> g) {
        return obj -> g.apply((InferenceRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationId;
        private RecommendationMetrics metrics;
        private EndpointOutputConfiguration endpointConfiguration;
        private ModelConfiguration modelConfiguration;
        private Instant invocationEndTime;
        private Instant invocationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceRecommendation model) {
            this.recommendationId(model.recommendationId);
            this.metrics(model.metrics);
            this.endpointConfiguration(model.endpointConfiguration);
            this.modelConfiguration(model.modelConfiguration);
            this.invocationEndTime(model.invocationEndTime);
            this.invocationStartTime(model.invocationStartTime);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final RecommendationMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(RecommendationMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(RecommendationMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final EndpointOutputConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointOutputConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointOutputConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final ModelConfiguration.Builder getModelConfiguration() {
            return this.modelConfiguration != null ? this.modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(ModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(ModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        public final Instant getInvocationEndTime() {
            return this.invocationEndTime;
        }

        public final void setInvocationEndTime(Instant invocationEndTime) {
            this.invocationEndTime = invocationEndTime;
        }

        @Override
        public final Builder invocationEndTime(Instant invocationEndTime) {
            this.invocationEndTime = invocationEndTime;
            return this;
        }

        public final Instant getInvocationStartTime() {
            return this.invocationStartTime;
        }

        public final void setInvocationStartTime(Instant invocationStartTime) {
            this.invocationStartTime = invocationStartTime;
        }

        @Override
        public final Builder invocationStartTime(Instant invocationStartTime) {
            this.invocationStartTime = invocationStartTime;
            return this;
        }

        public InferenceRecommendation build() {
            return new InferenceRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceRecommendation> {
        public Builder recommendationId(String var1);

        public Builder metrics(RecommendationMetrics var1);

        default public Builder metrics(Consumer<RecommendationMetrics.Builder> metrics) {
            return this.metrics((RecommendationMetrics)((RecommendationMetrics.Builder)RecommendationMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder endpointConfiguration(EndpointOutputConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointOutputConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointOutputConfiguration)((EndpointOutputConfiguration.Builder)EndpointOutputConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder modelConfiguration(ModelConfiguration var1);

        default public Builder modelConfiguration(Consumer<ModelConfiguration.Builder> modelConfiguration) {
            return this.modelConfiguration((ModelConfiguration)((ModelConfiguration.Builder)ModelConfiguration.builder().applyMutation(modelConfiguration)).build());
        }

        public Builder invocationEndTime(Instant var1);

        public Builder invocationStartTime(Instant var1);
    }
}

