/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHubRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateHubRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(UpdateHubRequest.getter(UpdateHubRequest::hubName)).setter(UpdateHubRequest.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDescription").getter(UpdateHubRequest.getter(UpdateHubRequest::hubDescription)).setter(UpdateHubRequest.setter(Builder::hubDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()}).build();
    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDisplayName").getter(UpdateHubRequest.getter(UpdateHubRequest::hubDisplayName)).setter(UpdateHubRequest.setter(Builder::hubDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()}).build();
    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubSearchKeywords").getter(UpdateHubRequest.getter(UpdateHubRequest::hubSearchKeywords)).setter(UpdateHubRequest.setter(Builder::hubSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_DESCRIPTION_FIELD, HUB_DISPLAY_NAME_FIELD, HUB_SEARCH_KEYWORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HubName", HUB_NAME_FIELD);
            this.put("HubDescription", HUB_DESCRIPTION_FIELD);
            this.put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
            this.put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
        }
    });
    private final String hubName;
    private final String hubDescription;
    private final String hubDisplayName;
    private final List<String> hubSearchKeywords;

    private UpdateHubRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubDescription = builder.hubDescription;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubSearchKeywords = builder.hubSearchKeywords;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubDescription() {
        return this.hubDescription;
    }

    public final String hubDisplayName() {
        return this.hubDisplayName;
    }

    public final boolean hasHubSearchKeywords() {
        return this.hubSearchKeywords != null && !(this.hubSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubSearchKeywords() {
        return this.hubSearchKeywords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHubRequest)) {
            return false;
        }
        UpdateHubRequest other = (UpdateHubRequest)((Object)obj);
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubDescription(), other.hubDescription()) && Objects.equals(this.hubDisplayName(), other.hubDisplayName()) && this.hasHubSearchKeywords() == other.hasHubSearchKeywords() && Objects.equals(this.hubSearchKeywords(), other.hubSearchKeywords());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHubRequest").add("HubName", (Object)this.hubName()).add("HubDescription", (Object)this.hubDescription()).add("HubDisplayName", (Object)this.hubDisplayName()).add("HubSearchKeywords", this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubDescription": {
                return Optional.ofNullable(clazz.cast(this.hubDescription()));
            }
            case "HubDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubDisplayName()));
            }
            case "HubSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubSearchKeywords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHubRequest, T> g) {
        return obj -> g.apply((UpdateHubRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hubName;
        private String hubDescription;
        private String hubDisplayName;
        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHubRequest model) {
            super(model);
            this.hubName(model.hubName);
            this.hubDescription(model.hubDescription);
            this.hubDisplayName(model.hubDisplayName);
            this.hubSearchKeywords(model.hubSearchKeywords);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubDescription() {
            return this.hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final String getHubDisplayName() {
            return this.hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (this.hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String ... hubSearchKeywords) {
            this.hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHubRequest build() {
            return new UpdateHubRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHubRequest> {
        public Builder hubName(String var1);

        public Builder hubDescription(String var1);

        public Builder hubDisplayName(String var1);

        public Builder hubSearchKeywords(Collection<String> var1);

        public Builder hubSearchKeywords(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

