/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonQSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonQSettings> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AmazonQSettings.getter(AmazonQSettings::statusAsString)).setter(AmazonQSettings.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> Q_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QProfileArn").getter(AmazonQSettings.getter(AmazonQSettings::qProfileArn)).setter(AmazonQSettings.setter(Builder::qProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QProfileArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, Q_PROFILE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("QProfileArn", Q_PROFILE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String qProfileArn;

    private AmazonQSettings(BuilderImpl builder) {
        this.status = builder.status;
        this.qProfileArn = builder.qProfileArn;
    }

    public final FeatureStatus status() {
        return FeatureStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String qProfileArn() {
        return this.qProfileArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qProfileArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonQSettings)) {
            return false;
        }
        AmazonQSettings other = (AmazonQSettings)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.qProfileArn(), other.qProfileArn());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonQSettings").add("Status", (Object)this.statusAsString()).add("QProfileArn", (Object)this.qProfileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "QProfileArn": {
                return Optional.ofNullable(clazz.cast(this.qProfileArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AmazonQSettings, T> g) {
        return obj -> g.apply((AmazonQSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String qProfileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonQSettings model) {
            this.status(model.status);
            this.qProfileArn(model.qProfileArn);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getQProfileArn() {
            return this.qProfileArn;
        }

        public final void setQProfileArn(String qProfileArn) {
            this.qProfileArn = qProfileArn;
        }

        @Override
        public final Builder qProfileArn(String qProfileArn) {
            this.qProfileArn = qProfileArn;
            return this;
        }

        public AmazonQSettings build() {
            return new AmazonQSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonQSettings> {
        public Builder status(String var1);

        public Builder status(FeatureStatus var1);

        public Builder qProfileArn(String var1);
    }
}

