/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelCardExportJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateModelCardExportJobRequest> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardName").getter(CreateModelCardExportJobRequest.getter(CreateModelCardExportJobRequest::modelCardName)).setter(CreateModelCardExportJobRequest.setter(Builder::modelCardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()}).build();
    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelCardVersion").getter(CreateModelCardExportJobRequest.getter(CreateModelCardExportJobRequest::modelCardVersion)).setter(CreateModelCardExportJobRequest.setter(Builder::modelCardVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()}).build();
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardExportJobName").getter(CreateModelCardExportJobRequest.getter(CreateModelCardExportJobRequest::modelCardExportJobName)).setter(CreateModelCardExportJobRequest.setter(Builder::modelCardExportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobName").build()}).build();
    private static final SdkField<ModelCardExportOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateModelCardExportJobRequest.getter(CreateModelCardExportJobRequest::outputConfig)).setter(CreateModelCardExportJobRequest.setter(Builder::outputConfig)).constructor(ModelCardExportOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD, MODEL_CARD_VERSION_FIELD, MODEL_CARD_EXPORT_JOB_NAME_FIELD, OUTPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ModelCardName", MODEL_CARD_NAME_FIELD);
            this.put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
            this.put("ModelCardExportJobName", MODEL_CARD_EXPORT_JOB_NAME_FIELD);
            this.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        }
    });
    private final String modelCardName;
    private final Integer modelCardVersion;
    private final String modelCardExportJobName;
    private final ModelCardExportOutputConfig outputConfig;

    private CreateModelCardExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.modelCardExportJobName = builder.modelCardExportJobName;
        this.outputConfig = builder.outputConfig;
    }

    public final String modelCardName() {
        return this.modelCardName;
    }

    public final Integer modelCardVersion() {
        return this.modelCardVersion;
    }

    public final String modelCardExportJobName() {
        return this.modelCardExportJobName;
    }

    public final ModelCardExportOutputConfig outputConfig() {
        return this.outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCardExportJobRequest)) {
            return false;
        }
        CreateModelCardExportJobRequest other = (CreateModelCardExportJobRequest)((Object)obj);
        return Objects.equals(this.modelCardName(), other.modelCardName()) && Objects.equals(this.modelCardVersion(), other.modelCardVersion()) && Objects.equals(this.modelCardExportJobName(), other.modelCardExportJobName()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelCardExportJobRequest").add("ModelCardName", (Object)this.modelCardName()).add("ModelCardVersion", (Object)this.modelCardVersion()).add("ModelCardExportJobName", (Object)this.modelCardExportJobName()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardName": {
                return Optional.ofNullable(clazz.cast(this.modelCardName()));
            }
            case "ModelCardVersion": {
                return Optional.ofNullable(clazz.cast(this.modelCardVersion()));
            }
            case "ModelCardExportJobName": {
                return Optional.ofNullable(clazz.cast(this.modelCardExportJobName()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCardExportJobRequest, T> g) {
        return obj -> g.apply((CreateModelCardExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelCardName;
        private Integer modelCardVersion;
        private String modelCardExportJobName;
        private ModelCardExportOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCardExportJobRequest model) {
            super(model);
            this.modelCardName(model.modelCardName);
            this.modelCardVersion(model.modelCardVersion);
            this.modelCardExportJobName(model.modelCardExportJobName);
            this.outputConfig(model.outputConfig);
        }

        public final String getModelCardName() {
            return this.modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return this.modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final String getModelCardExportJobName() {
            return this.modelCardExportJobName;
        }

        public final void setModelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
        }

        @Override
        public final Builder modelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
            return this;
        }

        public final ModelCardExportOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ModelCardExportOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ModelCardExportOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCardExportJobRequest build() {
            return new CreateModelCardExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelCardExportJobRequest> {
        public Builder modelCardName(String var1);

        public Builder modelCardVersion(Integer var1);

        public Builder modelCardExportJobName(String var1);

        public Builder outputConfig(ModelCardExportOutputConfig var1);

        default public Builder outputConfig(Consumer<ModelCardExportOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ModelCardExportOutputConfig)((ModelCardExportOutputConfig.Builder)ModelCardExportOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

