/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SageMakerImageName {
    SAGEMAKER_DISTRIBUTION("sagemaker_distribution"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SageMakerImageName> VALUE_MAP;
    private final String value;

    private SageMakerImageName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SageMakerImageName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SageMakerImageName> knownValues() {
        EnumSet<SageMakerImageName> knownValues = EnumSet.allOf(SageMakerImageName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SageMakerImageName.class, SageMakerImageName::toString);
    }
}

