/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FlatInvocations;
import software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold;
import software.amazon.awssdk.services.sagemaker.model.ModelLatencyThresholdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationJobStoppingConditions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationJobStoppingConditions> {
    private static final SdkField<Integer> MAX_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInvocations").getter(RecommendationJobStoppingConditions.getter(RecommendationJobStoppingConditions::maxInvocations)).setter(RecommendationJobStoppingConditions.setter(Builder::maxInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocations").build()}).build();
    private static final SdkField<List<ModelLatencyThreshold>> MODEL_LATENCY_THRESHOLDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelLatencyThresholds").getter(RecommendationJobStoppingConditions.getter(RecommendationJobStoppingConditions::modelLatencyThresholds)).setter(RecommendationJobStoppingConditions.setter(Builder::modelLatencyThresholds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatencyThresholds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelLatencyThreshold::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FLAT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlatInvocations").getter(RecommendationJobStoppingConditions.getter(RecommendationJobStoppingConditions::flatInvocationsAsString)).setter(RecommendationJobStoppingConditions.setter(Builder::flatInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlatInvocations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_INVOCATIONS_FIELD, MODEL_LATENCY_THRESHOLDS_FIELD, FLAT_INVOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MaxInvocations", MAX_INVOCATIONS_FIELD);
            this.put("ModelLatencyThresholds", MODEL_LATENCY_THRESHOLDS_FIELD);
            this.put("FlatInvocations", FLAT_INVOCATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer maxInvocations;
    private final List<ModelLatencyThreshold> modelLatencyThresholds;
    private final String flatInvocations;

    private RecommendationJobStoppingConditions(BuilderImpl builder) {
        this.maxInvocations = builder.maxInvocations;
        this.modelLatencyThresholds = builder.modelLatencyThresholds;
        this.flatInvocations = builder.flatInvocations;
    }

    public final Integer maxInvocations() {
        return this.maxInvocations;
    }

    public final boolean hasModelLatencyThresholds() {
        return this.modelLatencyThresholds != null && !(this.modelLatencyThresholds instanceof SdkAutoConstructList);
    }

    public final List<ModelLatencyThreshold> modelLatencyThresholds() {
        return this.modelLatencyThresholds;
    }

    public final FlatInvocations flatInvocations() {
        return FlatInvocations.fromValue(this.flatInvocations);
    }

    public final String flatInvocationsAsString() {
        return this.flatInvocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelLatencyThresholds() ? this.modelLatencyThresholds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.flatInvocationsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobStoppingConditions)) {
            return false;
        }
        RecommendationJobStoppingConditions other = (RecommendationJobStoppingConditions)obj;
        return Objects.equals(this.maxInvocations(), other.maxInvocations()) && this.hasModelLatencyThresholds() == other.hasModelLatencyThresholds() && Objects.equals(this.modelLatencyThresholds(), other.modelLatencyThresholds()) && Objects.equals(this.flatInvocationsAsString(), other.flatInvocationsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationJobStoppingConditions").add("MaxInvocations", (Object)this.maxInvocations()).add("ModelLatencyThresholds", this.hasModelLatencyThresholds() ? this.modelLatencyThresholds() : null).add("FlatInvocations", (Object)this.flatInvocationsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxInvocations": {
                return Optional.ofNullable(clazz.cast(this.maxInvocations()));
            }
            case "ModelLatencyThresholds": {
                return Optional.ofNullable(clazz.cast(this.modelLatencyThresholds()));
            }
            case "FlatInvocations": {
                return Optional.ofNullable(clazz.cast(this.flatInvocationsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobStoppingConditions, T> g) {
        return obj -> g.apply((RecommendationJobStoppingConditions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxInvocations;
        private List<ModelLatencyThreshold> modelLatencyThresholds = DefaultSdkAutoConstructList.getInstance();
        private String flatInvocations;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobStoppingConditions model) {
            this.maxInvocations(model.maxInvocations);
            this.modelLatencyThresholds(model.modelLatencyThresholds);
            this.flatInvocations(model.flatInvocations);
        }

        public final Integer getMaxInvocations() {
            return this.maxInvocations;
        }

        public final void setMaxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
        }

        @Override
        public final Builder maxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
            return this;
        }

        public final List<ModelLatencyThreshold.Builder> getModelLatencyThresholds() {
            List<ModelLatencyThreshold.Builder> result = ModelLatencyThresholdsCopier.copyToBuilder(this.modelLatencyThresholds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelLatencyThresholds(Collection<ModelLatencyThreshold.BuilderImpl> modelLatencyThresholds) {
            this.modelLatencyThresholds = ModelLatencyThresholdsCopier.copyFromBuilder(modelLatencyThresholds);
        }

        @Override
        public final Builder modelLatencyThresholds(Collection<ModelLatencyThreshold> modelLatencyThresholds) {
            this.modelLatencyThresholds = ModelLatencyThresholdsCopier.copy(modelLatencyThresholds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelLatencyThresholds(ModelLatencyThreshold ... modelLatencyThresholds) {
            this.modelLatencyThresholds(Arrays.asList(modelLatencyThresholds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelLatencyThresholds(Consumer<ModelLatencyThreshold.Builder> ... modelLatencyThresholds) {
            this.modelLatencyThresholds(Stream.of(modelLatencyThresholds).map(c -> (ModelLatencyThreshold)((ModelLatencyThreshold.Builder)ModelLatencyThreshold.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFlatInvocations() {
            return this.flatInvocations;
        }

        public final void setFlatInvocations(String flatInvocations) {
            this.flatInvocations = flatInvocations;
        }

        @Override
        public final Builder flatInvocations(String flatInvocations) {
            this.flatInvocations = flatInvocations;
            return this;
        }

        @Override
        public final Builder flatInvocations(FlatInvocations flatInvocations) {
            this.flatInvocations(flatInvocations == null ? null : flatInvocations.toString());
            return this;
        }

        public RecommendationJobStoppingConditions build() {
            return new RecommendationJobStoppingConditions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationJobStoppingConditions> {
        public Builder maxInvocations(Integer var1);

        public Builder modelLatencyThresholds(Collection<ModelLatencyThreshold> var1);

        public Builder modelLatencyThresholds(ModelLatencyThreshold ... var1);

        public Builder modelLatencyThresholds(Consumer<ModelLatencyThreshold.Builder> ... var1);

        public Builder flatInvocations(String var1);

        public Builder flatInvocations(FlatInvocations var1);
    }
}

