/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextClassificationJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextClassificationJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(TextClassificationJobConfig.getter(TextClassificationJobConfig::completionCriteria)).setter(TextClassificationJobConfig.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<String> CONTENT_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentColumn").getter(TextClassificationJobConfig.getter(TextClassificationJobConfig::contentColumn)).setter(TextClassificationJobConfig.setter(Builder::contentColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentColumn").build()}).build();
    private static final SdkField<String> TARGET_LABEL_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLabelColumn").getter(TextClassificationJobConfig.getter(TextClassificationJobConfig::targetLabelColumn)).setter(TextClassificationJobConfig.setter(Builder::targetLabelColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLabelColumn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD, CONTENT_COLUMN_FIELD, TARGET_LABEL_COLUMN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CompletionCriteria", COMPLETION_CRITERIA_FIELD);
            this.put("ContentColumn", CONTENT_COLUMN_FIELD);
            this.put("TargetLabelColumn", TARGET_LABEL_COLUMN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final String contentColumn;
    private final String targetLabelColumn;

    private TextClassificationJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.contentColumn = builder.contentColumn;
        this.targetLabelColumn = builder.targetLabelColumn;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final String contentColumn() {
        return this.contentColumn;
    }

    public final String targetLabelColumn() {
        return this.targetLabelColumn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLabelColumn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextClassificationJobConfig)) {
            return false;
        }
        TextClassificationJobConfig other = (TextClassificationJobConfig)obj;
        return Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.contentColumn(), other.contentColumn()) && Objects.equals(this.targetLabelColumn(), other.targetLabelColumn());
    }

    public final String toString() {
        return ToString.builder((String)"TextClassificationJobConfig").add("CompletionCriteria", (Object)this.completionCriteria()).add("ContentColumn", (Object)this.contentColumn()).add("TargetLabelColumn", (Object)this.targetLabelColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "ContentColumn": {
                return Optional.ofNullable(clazz.cast(this.contentColumn()));
            }
            case "TargetLabelColumn": {
                return Optional.ofNullable(clazz.cast(this.targetLabelColumn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TextClassificationJobConfig, T> g) {
        return obj -> g.apply((TextClassificationJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;
        private String contentColumn;
        private String targetLabelColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(TextClassificationJobConfig model) {
            this.completionCriteria(model.completionCriteria);
            this.contentColumn(model.contentColumn);
            this.targetLabelColumn(model.targetLabelColumn);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getContentColumn() {
            return this.contentColumn;
        }

        public final void setContentColumn(String contentColumn) {
            this.contentColumn = contentColumn;
        }

        @Override
        public final Builder contentColumn(String contentColumn) {
            this.contentColumn = contentColumn;
            return this;
        }

        public final String getTargetLabelColumn() {
            return this.targetLabelColumn;
        }

        public final void setTargetLabelColumn(String targetLabelColumn) {
            this.targetLabelColumn = targetLabelColumn;
        }

        @Override
        public final Builder targetLabelColumn(String targetLabelColumn) {
            this.targetLabelColumn = targetLabelColumn;
            return this;
        }

        public TextClassificationJobConfig build() {
            return new TextClassificationJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextClassificationJobConfig> {
        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder contentColumn(String var1);

        public Builder targetLabelColumn(String var1);
    }
}

