/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.TargetTrackingScalingPolicyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<TargetTrackingScalingPolicyConfiguration> TARGET_TRACKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTracking").getter(ScalingPolicy.getter(ScalingPolicy::targetTracking)).setter(ScalingPolicy.setter(Builder::targetTracking)).constructor(TargetTrackingScalingPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTracking").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TRACKING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TargetTracking", TARGET_TRACKING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final TargetTrackingScalingPolicyConfiguration targetTracking;
    private final Type type;

    private ScalingPolicy(BuilderImpl builder) {
        this.targetTracking = builder.targetTracking;
        this.type = builder.type;
    }

    public final TargetTrackingScalingPolicyConfiguration targetTracking() {
        return this.targetTracking;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTracking());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.targetTracking(), other.targetTracking());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPolicy").add("TargetTracking", (Object)this.targetTracking()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetTracking": {
                return Optional.ofNullable(clazz.cast(this.targetTracking()));
            }
        }
        return Optional.empty();
    }

    public static ScalingPolicy fromTargetTracking(TargetTrackingScalingPolicyConfiguration targetTracking) {
        return (ScalingPolicy)ScalingPolicy.builder().targetTracking(targetTracking).build();
    }

    public static ScalingPolicy fromTargetTracking(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTracking) {
        TargetTrackingScalingPolicyConfiguration.Builder builder = TargetTrackingScalingPolicyConfiguration.builder();
        targetTracking.accept(builder);
        return ScalingPolicy.fromTargetTracking((TargetTrackingScalingPolicyConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TARGET_TRACKING,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TargetTrackingScalingPolicyConfiguration targetTracking;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.targetTracking(model.targetTracking);
        }

        public final TargetTrackingScalingPolicyConfiguration.Builder getTargetTracking() {
            return this.targetTracking != null ? this.targetTracking.toBuilder() : null;
        }

        public final void setTargetTracking(TargetTrackingScalingPolicyConfiguration.BuilderImpl targetTracking) {
            TargetTrackingScalingPolicyConfiguration oldValue = this.targetTracking;
            this.targetTracking = targetTracking != null ? targetTracking.build() : null;
            this.handleUnionValueChange(Type.TARGET_TRACKING, oldValue, this.targetTracking);
        }

        @Override
        public final Builder targetTracking(TargetTrackingScalingPolicyConfiguration targetTracking) {
            TargetTrackingScalingPolicyConfiguration oldValue = this.targetTracking;
            this.targetTracking = targetTracking;
            this.handleUnionValueChange(Type.TARGET_TRACKING, oldValue, this.targetTracking);
            return this;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder targetTracking(TargetTrackingScalingPolicyConfiguration var1);

        default public Builder targetTracking(Consumer<TargetTrackingScalingPolicyConfiguration.Builder> targetTracking) {
            return this.targetTracking((TargetTrackingScalingPolicyConfiguration)((TargetTrackingScalingPolicyConfiguration.Builder)TargetTrackingScalingPolicyConfiguration.builder().applyMutation(targetTracking)).build());
        }
    }
}

